/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.targeters;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.targeters.IEntitySelector;
import io.lumine.xikage.mythicmobs.utils.tasks.Scheduler;
import java.util.Collection;
import java.util.HashSet;

public class MobsNearOriginTargeter
extends IEntitySelector {
    double radius;
    HashSet<MythicMob> mmTypes = new HashSet();
    HashSet<BukkitEntityType> meTypes = new HashSet();

    public MobsNearOriginTargeter(MythicLineConfig mlc) {
        super(mlc);
        this.radius = mlc.getDouble("radius", 5.0);
        this.radius = mlc.getDouble("r", this.radius);
        String types = mlc.getString("types", null);
        types = mlc.getString("type", types);
        types = mlc.getString("t", types);
        String[] ss = types.split(",");
        MobsNearOriginTargeter THIS = this;
        Scheduler.runLaterSync(() -> {
            for (String s2 : ss) {
                MythicMob mm3 = MythicMobs.inst().getMobManager().getMythicMob(s2);
                if (mm3 != null) {
                    THIS.mmTypes.add(mm3);
                    continue;
                }
                BukkitEntityType me = BukkitEntityType.getMythicEntity(s2);
                if (me != null) {
                    THIS.meTypes.add(me);
                    continue;
                }
                MythicLogger.errorTargeterConfig(this, mlc, "The 'type' attribute must be a valid MythicMob or MythicEntity type.");
            }
        }, 5L);
    }

    @Override
    public Collection<AbstractEntity> getEntities(SkillMetadata data) {
        HashSet<AbstractEntity> targets = new HashSet<AbstractEntity>();
        block0: for (AbstractEntity p : MythicMobs.inst().getEntityManager().getLivingEntities(data.getCaster().getEntity().getWorld())) {
            if (p.getUniqueId().equals(data.getCaster().getEntity().getUniqueId()) || !p.getWorld().equals(data.getCaster().getEntity().getWorld()) || !(data.getOrigin().distanceSquared(p.getLocation()) < Math.pow(this.radius, 2.0))) continue;
            ActiveMob amx = MythicMobs.inst().getMobManager().getMythicMobInstance(p);
            if (amx != null) {
                if (!this.mmTypes.contains(amx.getType())) continue;
                targets.add(p);
                amx = null;
                continue;
            }
            for (BukkitEntityType me : this.meTypes) {
                if (!me.compare(p.getBukkitEntity())) continue;
                targets.add(p);
                continue block0;
            }
        }
        return targets;
    }
}

