/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.targeters;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.targeters.IEntitySelector;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import java.util.Collection;
import java.util.HashSet;

public class MobsInRadiusTargeter
extends IEntitySelector {
    private double radius;
    private double radiusSq;
    private HashSet<MythicMob> mmTypes = new HashSet();
    private HashSet<BukkitEntityType> meTypes = new HashSet();

    public MobsInRadiusTargeter(MythicLineConfig mlc) {
        super(mlc);
        this.radius = mlc.getDouble(new String[]{"radius", "r"}, 5.0);
        this.radiusSq = Math.pow(this.radius, 2.0);
        String types = mlc.getString(new String[]{"types", "type", "t"}, "", new String[0]);
        String[] ss = types.split(",");
        MobsInRadiusTargeter THIS = this;
        Schedulers.sync().runLater(() -> {
            for (String s2 : ss) {
                MythicMob mm3 = MythicMobs.inst().getMobManager().getMythicMob(s2);
                if (mm3 != null) {
                    THIS.mmTypes.add(mm3);
                    continue;
                }
                BukkitEntityType me = BukkitEntityType.getMythicEntity(s2);
                if (me != null) {
                    THIS.meTypes.add(me);
                    continue;
                }
                MythicLogger.errorTargeterConfig(this, mlc, "The 'type' attribute must be a valid MythicMob or MythicEntity type.");
            }
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "@MIR targeter loaded targeting " + (THIS.meTypes.size() + THIS.mmTypes.size()) + " types", new Object[0]);
        }, 5L);
    }

    @Override
    public Collection<AbstractEntity> getEntities(SkillMetadata data) {
        SkillCaster am = data.getCaster();
        AbstractEntity caster = am.getEntity();
        HashSet<AbstractEntity> targets = new HashSet<AbstractEntity>();
        if (this.radius > 128.0) {
            block0: for (AbstractEntity p : MythicMobs.inst().getEntityManager().getLivingEntities(am.getEntity().getWorld())) {
                if (p.getUniqueId().equals(am.getEntity().getUniqueId()) || !p.getWorld().equals(am.getEntity().getWorld()) || !(am.getEntity().getLocation().distanceSquared(p.getLocation()) <= this.radiusSq)) continue;
                ActiveMob amx = MobsInRadiusTargeter.getPlugin().getMobManager().getMythicMobInstance(p);
                if (amx != null) {
                    if (!this.mmTypes.contains(amx.getType())) continue;
                    targets.add(p);
                    amx = null;
                    continue;
                }
                for (BukkitEntityType me : this.meTypes) {
                    if (!me.compare(p.getBukkitEntity())) continue;
                    targets.add(p);
                    continue block0;
                }
            }
        } else {
            targets.addAll(MobsInRadiusTargeter.getPlugin().getVolatileCodeHandler().getWorldHandler().getEntitiesNearLocation(am.getLocation(), this.radius, entity -> {
                if (entity.getUniqueId().equals(am.getEntity().getUniqueId())) {
                    return false;
                }
                if (caster.getLocation().distanceSquared(entity.getLocation()) > this.radiusSq) {
                    return false;
                }
                ActiveMob amCompare = MobsInRadiusTargeter.getPlugin().getMobManager().getMythicMobInstance((AbstractEntity)entity);
                if (amCompare != null) {
                    if (this.mmTypes.contains(amCompare.getType())) {
                        return true;
                    }
                } else {
                    for (BukkitEntityType me : this.meTypes) {
                        if (!me.compare(entity.getBukkitEntity())) continue;
                        return true;
                    }
                }
                return false;
            }));
        }
        return targets;
    }
}

