/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.targeters;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractVector;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.targeters.IEntitySelector;
import io.lumine.xikage.mythicmobs.util.annotations.MythicTargeter;
import java.util.Collection;
import java.util.HashSet;

@MythicTargeter(author="Ashijin", name="livingInCone", aliases={"entitiesInCone", "livingEntitiesInCone", "LEIC", "EIC"}, description="Targets random points in a cone shape")
public class LivingInConeTargeter
extends IEntitySelector {
    protected double angle;
    protected double range;
    protected double rotation;

    public LivingInConeTargeter(MythicLineConfig mlc) {
        super(mlc);
        this.angle = mlc.getDouble(new String[]{"angle", "a"}, 90.0);
        this.range = mlc.getDouble(new String[]{"range", "r"}, 16.0);
        this.rotation = mlc.getDouble(new String[]{"rotation", "rot"}, 0.0);
    }

    @Override
    public Collection<AbstractEntity> getEntities(SkillMetadata data) {
        SkillCaster am = data.getCaster();
        HashSet<AbstractEntity> possible = new HashSet<AbstractEntity>();
        for (AbstractEntity p : MythicMobs.inst().getEntityManager().getLivingEntities(am.getEntity().getWorld())) {
            if (!am.getLocation().getWorld().equals(p.getWorld()) || p.getUniqueId().equals(am.getEntity().getUniqueId()) || !(am.getEntity().getLocation().distanceSquared(p.getLocation()) < Math.pow(this.range, 2.0))) continue;
            possible.add(p);
        }
        HashSet<AbstractEntity> targets = new HashSet<AbstractEntity>();
        AbstractVector dir = data.getCaster().getLocation().getDirection();
        if (this.rotation > 0.0) {
            dir.rotate((float)this.rotation);
        }
        dir.setY(0);
        double cos = Math.cos(this.angle * Math.PI / 180.0);
        double cosSq = cos * cos;
        possible.forEach(entity -> {
            AbstractVector relative = entity.getLocation().subtract(data.getCaster().getLocation()).toVector();
            relative.setY(0);
            double dot = relative.getX() * dir.getX() + relative.getY() * dir.getY() + relative.getZ() * dir.getZ();
            double value = dot * dot / relative.lengthSquared();
            if (this.angle < 180.0 && dot > 0.0 && value >= cosSq) {
                targets.add((AbstractEntity)entity);
            } else if (this.angle >= 180.0 && (dot > 0.0 || dot <= cosSq)) {
                targets.add((AbstractEntity)entity);
            }
        });
        return targets;
    }
}

