/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.targeters;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractVector;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.targeters.ILocationSelector;
import io.lumine.xikage.mythicmobs.util.annotations.MythicTargeter;
import java.util.Collection;
import java.util.HashSet;

@MythicTargeter(author="Ashijin", name="line", aliases={}, description="Targets points in a line from the caster to the target location")
public class LineTargeter
extends ILocationSelector {
    protected float radius = 1.0f;
    protected float radiusSq;
    protected boolean fromOrigin = false;

    public LineTargeter(MythicLineConfig mlc) {
        super(mlc);
        this.radius = mlc.getFloat(new String[]{"radius", "r"}, this.radius);
        this.fromOrigin = mlc.getBoolean(new String[]{"fromorigin", "fo"}, false);
        this.radiusSq = this.radius * this.radius;
    }

    @Override
    public Collection<AbstractLocation> getLocations(SkillMetadata data) {
        HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
        AbstractLocation sl = this.fromOrigin ? data.getOrigin().clone() : data.getCaster().getLocation();
        double range = 1.0;
        if (data.getLocationTargets() != null && data.getLocationTargets().size() > 0) {
            for (AbstractLocation l2 : data.getLocationTargets()) {
                double d = l2.distanceSquared(sl);
                if (!(d > range)) continue;
                range = d;
            }
        } else if (data.getEntityTargets() != null && data.getEntityTargets().size() > 0) {
            for (AbstractEntity l3 : data.getEntityTargets()) {
                double d = l3.getLocation().distanceSquared(sl);
                if (!(d > range)) continue;
                range = d;
            }
        } else {
            return targets;
        }
        if (data.getLocationTargets() != null && data.getLocationTargets().size() > 0) {
            data.getLocationTargets().forEach(l -> {
                int c = (int)Math.ceil(sl.distance((AbstractLocation)l) / (double)this.radius) - 1;
                if (c <= 0) {
                    return;
                }
                AbstractVector v = l.toVector().subtract(sl.toVector()).normalize().multiply(this.radius);
                AbstractLocation l2 = sl.clone();
                for (int i = 0; i < c; ++i) {
                    l2.add(v);
                    targets.add(l2.clone());
                }
            });
        } else if (data.getEntityTargets() != null && data.getEntityTargets().size() > 0) {
            data.getEntityTargets().forEach(ee -> {
                AbstractLocation l = ee.getLocation();
                int c = (int)Math.ceil(sl.distance(l) / (double)this.radius) - 1;
                if (c <= 0) {
                    return;
                }
                AbstractVector v = l.toVector().subtract(sl.toVector()).normalize().multiply(this.radius);
                AbstractLocation l2 = sl.clone();
                for (int i = 0; i < c; ++i) {
                    l2.add(v);
                    targets.add(l2.clone());
                }
            });
        }
        return targets;
    }
}

