/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.targeters;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.targeters.IEntitySelector;
import io.lumine.xikage.mythicmobs.util.annotations.MythicTargeter;
import java.util.Collection;
import java.util.HashSet;
import org.bukkit.entity.Item;

@MythicTargeter(author="Ashijin", name="itemsNearOrigin", aliases={"INO"}, description="Gets all items in a radius around the origin")
public class ItemsNearOriginTargeter
extends IEntitySelector {
    double radius;

    public ItemsNearOriginTargeter(MythicLineConfig mlc) {
        super(mlc);
        this.radius = mlc.getDouble("radius", 5.0);
        this.radius = mlc.getDouble("r", this.radius);
    }

    @Override
    public Collection<AbstractEntity> getEntities(SkillMetadata data) {
        HashSet<AbstractEntity> targets = new HashSet<AbstractEntity>();
        for (AbstractEntity p : ItemsNearOriginTargeter.getPlugin().getVolatileCodeHandler().getWorldHandler().getEntitiesNearLocation(data.getOrigin(), this.radius, ae -> ae.getBukkitEntity() instanceof Item)) {
            if (!(data.getOrigin().distanceSquared(p.getLocation()) < Math.pow(this.radius, 2.0))) continue;
            targets.add(p);
        }
        return targets;
    }
}

