/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.targeters;

import com.google.common.collect.Sets;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.targeters.IEntitySelector;
import io.lumine.xikage.mythicmobs.util.annotations.MythicTargeter;
import java.util.Collection;
import java.util.HashSet;
import org.bukkit.entity.Item;

@MythicTargeter(author="Ashijin", name="itemsInRadius", aliases={"IIR"}, description="Gets all items in a radius around the caster")
public class ItemsInRadiusTargeter
extends IEntitySelector {
    private double radius;

    public ItemsInRadiusTargeter(MythicLineConfig mlc) {
        super(mlc);
        this.radius = mlc.getDouble(new String[]{"radius", "r"}, 5.0);
    }

    @Override
    public Collection<AbstractEntity> getEntities(SkillMetadata data) {
        SkillCaster am = data.getCaster();
        HashSet<AbstractEntity> targets = Sets.newHashSet();
        for (AbstractEntity p : ItemsInRadiusTargeter.getPlugin().getVolatileCodeHandler().getWorldHandler().getEntitiesNearLocation(am.getLocation(), this.radius, ae -> ae.getBukkitEntity() instanceof Item)) {
            if (!(am.getEntity().getLocation().distanceSquared(p.getLocation()) < Math.pow(this.radius, 2.0))) continue;
            targets.add(p);
        }
        return targets;
    }
}

