/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.targeters;

import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillTargeter;
import io.lumine.xikage.mythicmobs.util.MythicUtil;
import java.util.Collection;

public abstract class ILocationSelector
extends SkillTargeter {
    protected double xoffset;
    protected double yoffset;
    protected double zoffset;
    protected double forwardOffset;
    protected double sideOffset;
    protected double rotateX;
    protected double rotateY;
    protected double rotateZ;
    protected double length;
    protected boolean advOffset = false;
    protected boolean rotated = false;

    public ILocationSelector(MythicLineConfig mlc) {
        super(mlc);
        this.xoffset = mlc.getDouble(new String[]{"xoffset", "xo", "x"}, 0.0);
        this.yoffset = mlc.getDouble(new String[]{"yoffset", "yo", "y"}, 0.0);
        this.zoffset = mlc.getDouble(new String[]{"zoffset", "zo", "z"}, 0.0);
        this.forwardOffset = mlc.getDouble(new String[]{"forwardoffset", "foffset", "fo"}, 0.0);
        this.sideOffset = mlc.getDouble(new String[]{"sideoffset", "soffset", "so"}, 0.0);
        this.rotateX = mlc.getDouble(new String[]{"rotatex", "rotx"}, 0.0);
        this.rotateY = mlc.getDouble(new String[]{"rotatey", "roty"}, 0.0);
        this.rotateZ = mlc.getDouble(new String[]{"rotatez", "rotz"}, 0.0);
        this.length = mlc.getDouble(new String[]{"length"}, 0.0);
        if (this.forwardOffset != 0.0 || this.sideOffset != 0.0) {
            this.advOffset = true;
        }
        if (this.rotateX != 0.0 || this.rotateY != 0.0 || this.rotateZ != 0.0) {
            this.rotated = true;
        }
    }

    public abstract Collection<AbstractLocation> getLocations(SkillMetadata var1);

    public void filter(SkillMetadata data) {
        if (this.targetConditions != null) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "+ Applying target conditions", new Object[0]);
            for (SkillCondition mc : this.targetConditions) {
                if (mc.evaluateTargets(data)) continue;
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! Skill not usable: TargetConditions failed.", new Object[0]);
                return;
            }
        }
    }

    public AbstractLocation mutate(SkillMetadata data, AbstractLocation location) {
        if (this.xoffset != 0.0 || this.yoffset != 0.0 || this.zoffset != 0.0) {
            location = location.clone().add(this.xoffset, this.yoffset, this.zoffset);
        }
        if (this.advOffset) {
            location = MythicUtil.move(location, this.forwardOffset, 0.0, this.sideOffset);
        }
        if (this.length != 0.0) {
            location = location.add(location.getDirection().clone().multiply(this.length));
        }
        return location;
    }
}

