/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.targeters;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.SelfTargeter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.entity.ArmorStand;
import org.bukkit.metadata.MetadataValue;

public abstract class IEntitySelector
extends SkillTargeter {
    private boolean targetSelf = false;
    private boolean targetPlayers = true;
    private boolean targetArmorStands = true;
    private boolean targetCreativeMode = true;
    private boolean targetSpectatorMode = true;
    private boolean targetCitizensNPCs = false;
    private boolean targetAnimals = true;
    private boolean targetCreatures = true;
    private boolean targetMonsters = true;
    private boolean targetWaterMobs = true;
    private boolean targetFlyingMobs = true;
    private boolean targetSameFaction = true;
    private boolean targetOwner = true;
    private boolean targetNonMythic = true;
    private int limit = 0;
    private FilterSorter sorter = FilterSorter.NONE;
    private List<String> ignoreTypes = null;
    private List<SkillCondition> conditions = null;

    public IEntitySelector(MythicLineConfig mlc) {
        super(mlc);
        this.limit = mlc.getInteger(new String[]{"limit"}, 0);
        String sort = mlc.getString(new String[]{"sort", "sortby"}, "NONE", new String[0]).toUpperCase();
        try {
            this.sorter = FilterSorter.valueOf(sort);
        }
        catch (Exception ex) {
            MythicLogger.errorTargeterConfig(this, mlc, "'" + sort + "' is not a valid sorter.");
        }
        if (this instanceof SelfTargeter) {
            this.targetSelf = true;
        }
        String target = mlc.getString("target", null);
        String ignore = mlc.getString("ignore", null);
        String ignoreTypes = mlc.getString("ignoretype", null);
        if (target != null) {
            this.targetPlayers = false;
            this.targetArmorStands = false;
            this.targetCreativeMode = false;
            this.targetSpectatorMode = false;
            this.targetCitizensNPCs = false;
            this.targetAnimals = false;
            this.targetCreatures = false;
            this.targetMonsters = false;
            this.targetWaterMobs = false;
            this.targetFlyingMobs = false;
            if (target.contains("self") || target.contains("caster")) {
                this.targetSelf = true;
            }
            if (target.contains("player")) {
                this.targetPlayers = true;
            }
            if (target.contains("creative")) {
                this.targetCreativeMode = true;
            }
            if (target.contains("armorstand") || ignore.contains("armor_stand")) {
                this.targetArmorStands = true;
            }
            if (target.contains("spectator")) {
                this.targetSpectatorMode = true;
            }
            if (target.contains("npc")) {
                this.targetCitizensNPCs = true;
            }
            if (target.contains("animal")) {
                this.targetAnimals = true;
            }
            if (target.contains("monster")) {
                this.targetMonsters = true;
            }
            if (target.contains("creatures")) {
                this.targetCreatures = true;
            }
        }
        if (ignore != null) {
            if (ignore.contains("player")) {
                this.targetPlayers = false;
            }
            if (ignore.contains("creative")) {
                this.targetCreativeMode = false;
            }
            if (ignore.contains("armorstand") || ignore.contains("armor_stand")) {
                this.targetArmorStands = false;
            }
            if (ignore.contains("spectator")) {
                this.targetSpectatorMode = false;
            }
            if (ignore.contains("npc")) {
                this.targetCitizensNPCs = false;
            }
            if (ignore.contains("animal")) {
                this.targetAnimals = false;
            }
            if (ignore.contains("monsters")) {
                this.targetMonsters = false;
            }
            if (ignore.contains("creatures")) {
                this.targetCreatures = false;
            }
            if (ignore.contains("faction")) {
                this.targetSameFaction = false;
            }
            if (ignore.contains("vanilla")) {
                this.targetNonMythic = false;
            }
        }
        if (ignoreTypes != null) {
            this.ignoreTypes = new ArrayList<String>();
            for (String s2 : ignoreTypes.split(",")) {
                this.ignoreTypes.add(s2);
            }
        }
        this.targetSelf = mlc.getBoolean("targetself", this.targetSelf);
        this.targetPlayers = mlc.getBoolean("targetplayers", this.targetPlayers);
        this.targetCreativeMode = mlc.getBoolean("targetcreative", this.targetCreativeMode);
        this.targetSpectatorMode = mlc.getBoolean("targetspectator", this.targetSpectatorMode);
        this.targetCitizensNPCs = mlc.getBoolean("targetnpcs", this.targetCitizensNPCs);
        this.targetAnimals = mlc.getBoolean("targetanimals", this.targetAnimals);
        this.targetCreatures = mlc.getBoolean("targetcreatures", this.targetCreatures);
        this.targetSameFaction = mlc.getBoolean("targetsamefaction", this.targetSameFaction);
        this.targetOwner = mlc.getBoolean("targetowner", this.targetOwner);
        this.targetNonMythic = mlc.getBoolean(new String[]{"targetvanilla", "targetnonmythic"}, this.targetNonMythic);
    }

    public abstract Collection<AbstractEntity> getEntities(SkillMetadata var1);

    public void filter(SkillMetadata data, boolean targetCreative) {
        if (this.targetConditions != null) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "+ Applying target conditions", new Object[0]);
            for (SkillCondition mc : this.targetConditions) {
                if (mc.evaluateTargets(data)) continue;
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! Skill not usable: TargetConditions failed.", new Object[0]);
                return;
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "+ Applying entity target filters", new Object[0]);
        Collection targets = data.getEntityTargets();
        if (targets == null) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "+ No targets to filter?", new Object[0]);
            return;
        }
        targets.removeIf(t -> {
            ActiveMob am;
            if (t == null) {
                return true;
            }
            if (!this.targetSelf && !(this instanceof SelfTargeter) && t.getUniqueId().equals(data.getCaster().getEntity().getUniqueId())) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Filtering SELF", new Object[0]);
                return true;
            }
            if (!this.targetPlayers) {
                if (t.isPlayer()) {
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Filtering PLAYER", new Object[0]);
                    return true;
                }
            } else {
                if ((!this.targetCreativeMode || !targetCreative) && t.isPlayer() && t.asPlayer().isInCreativeMode()) {
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Filtering CREATIVE", new Object[0]);
                    return true;
                }
                if ((!this.targetSpectatorMode || !targetCreative) && t.isPlayer() && t.asPlayer().isInSpectatorMode()) {
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Filtering SPECTATOR", new Object[0]);
                    return true;
                }
            }
            if (!this.targetArmorStands && t.getBukkitEntity() instanceof ArmorStand) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Filtering ARMOR_STAND", new Object[0]);
                return true;
            }
            if (!this.targetAnimals && t.isAnimal()) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Filtering ANIMAL", new Object[0]);
                return true;
            }
            if (!this.targetCreatures && t.isCreature()) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Filtering CREATURE", new Object[0]);
                return true;
            }
            if (!this.targetMonsters && t.isMonster()) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Filtering MONSTER", new Object[0]);
                return true;
            }
            if (!this.targetCitizensNPCs && t.isLiving() && t.getBukkitEntity().hasMetadata("NPC")) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Filtering NPC", new Object[0]);
                return true;
            }
            if (!this.targetNonMythic && !MythicMobs.inst().getMobManager().isActiveMob((AbstractEntity)t)) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Filtering NON-MYTHIC", new Object[0]);
                return true;
            }
            if (!this.targetSameFaction) {
                am = (ActiveMob)data.getCaster();
                if (t.isLiving() && t.getBukkitEntity().hasMetadata("Faction")) {
                    List md = t.getBukkitEntity().getMetadata("Faction");
                    for (MetadataValue v : md) {
                        if (!v.asString().equals(am.getFaction())) continue;
                        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Filtering SAMEFACTION", new Object[0]);
                        return true;
                    }
                }
            }
            if (!this.targetOwner && (am = (ActiveMob)data.getCaster()).getOwner().isPresent() && am.getOwner().get().equals(t.getUniqueId())) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Filtering OWNER", new Object[0]);
                return true;
            }
            return false;
        });
        if (this.limit > 0) {
            switch (this.sorter) {
                case NEAREST: {
                    AbstractLocation origin = data.getOrigin();
                    targets = targets.stream().sorted((o1, o2) -> {
                        double d1 = origin.distanceSquared(o1.getLocation());
                        double d2 = origin.distanceSquared(o2.getLocation());
                        return Double.compare(d1, d2);
                    }).limit(this.limit).collect(Collectors.toCollection(HashSet::new));
                    break;
                }
                case FURTHEST: {
                    AbstractLocation origin = data.getOrigin();
                    targets = targets.stream().sorted((o1, o2) -> {
                        double d1 = origin.distanceSquared(o1.getLocation());
                        double d2 = origin.distanceSquared(o2.getLocation());
                        return Double.compare(d2, d1);
                    }).limit(this.limit).collect(Collectors.toCollection(HashSet::new));
                    break;
                }
                case HIGHEST_HEALTH: {
                    targets = targets.stream().sorted((o1, o2) -> {
                        double d1 = o1.getHealth();
                        double d2 = o2.getHealth();
                        return Double.compare(d2, d1);
                    }).limit(this.limit).collect(Collectors.toCollection(HashSet::new));
                    break;
                }
                case LOWEST_HEALTH: {
                    targets = targets.stream().sorted((o1, o2) -> {
                        double d1 = o1.getHealth();
                        double d2 = o2.getHealth();
                        return Double.compare(d1, d2);
                    }).limit(this.limit).collect(Collectors.toCollection(HashSet::new));
                    break;
                }
                case HIGHEST_THREAT: {
                    if (!(data.getCaster() instanceof ActiveMob) || !((ActiveMob)data.getCaster()).hasThreatTable()) {
                        MythicLogger.errorTargeterConfig(this, this.config, "Threat sorters can only be used with mobs that have ThreatTables enabled");
                    }
                    ActiveMob am = (ActiveMob)data.getCaster();
                    ActiveMob.ThreatTable tt = am.getThreatTable();
                    targets = targets.stream().sorted((o1, o2) -> {
                        double d1 = tt.getThreat((AbstractEntity)o1);
                        double d2 = tt.getThreat((AbstractEntity)o2);
                        return Double.compare(d2, d1);
                    }).limit(this.limit).collect(Collectors.toCollection(HashSet::new));
                    break;
                }
                case LOWEST_THREAT: {
                    if (!(data.getCaster() instanceof ActiveMob) || !((ActiveMob)data.getCaster()).hasThreatTable()) {
                        MythicLogger.errorTargeterConfig(this, this.config, "Threat sorters can only be used with mobs that have ThreatTables enabled");
                    }
                    ActiveMob am = (ActiveMob)data.getCaster();
                    ActiveMob.ThreatTable tt = am.getThreatTable();
                    targets = targets.stream().sorted((o1, o2) -> {
                        double d1 = tt.getThreat((AbstractEntity)o1);
                        double d2 = tt.getThreat((AbstractEntity)o2);
                        return Double.compare(d1, d2);
                    }).limit(this.limit).collect(Collectors.toCollection(HashSet::new));
                    break;
                }
                case RANDOM: {
                    targets = targets.stream().collect(Collectors.collectingAndThen(Collectors.toList(), collected -> {
                        Collections.shuffle(collected);
                        return collected.stream();
                    })).limit(this.limit).collect(Collectors.toCollection(HashSet::new));
                    break;
                }
                default: {
                    targets = targets.stream().limit(this.limit).collect(Collectors.toCollection(HashSet::new));
                }
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Returning {0} targets", targets.size());
        data.setEntityTargets(targets);
    }

    private static enum FilterSorter {
        NONE,
        RANDOM,
        NEAREST,
        FURTHEST,
        HIGHEST_HEALTH,
        LOWEST_HEALTH,
        HIGHEST_THREAT,
        LOWEST_THREAT;

    }
}

