/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.targeters;

import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.targeters.ILocationSelector;
import io.lumine.xikage.mythicmobs.util.annotations.MythicTargeter;
import java.util.Collection;
import java.util.HashSet;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

@MythicTargeter(author="Ashijin", name="forwardwall", aliases={}, description="Targets a plane in front of the caster")
public class ForwardWallTargeter
extends ILocationSelector {
    protected double forward;
    protected double yoffset;
    protected int height;
    protected int width;

    public ForwardWallTargeter(MythicLineConfig mlc) {
        super(mlc);
        this.forward = mlc.getDouble(new String[]{"forward", "f", "amount", "a"}, 5.0);
        this.yoffset = mlc.getDouble(new String[]{"yoffset", "y"}, 0.0);
        this.height = mlc.getInteger(new String[]{"height", "h"}, 2);
        this.width = mlc.getInteger(new String[]{"width", "w"}, 3);
    }

    @Override
    public Collection<AbstractLocation> getLocations(SkillMetadata data) {
        SkillCaster am = data.getCaster();
        HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
        AbstractLocation location = am.getEntity().getLocation().add(am.getEntity().getLocation().getDirection().normalize().multiply(this.forward)).add(0.0, this.yoffset, 0.0);
        targets.add(location);
        Location base = BukkitAdapter.adapt(location);
        float yaw = Math.round(am.getLocation().getYaw() / 90.0f);
        BlockFace right = ForwardWallTargeter.getRight(yaw);
        for (int h2 = -this.height; h2 <= this.height; ++h2) {
            Block add = base.getBlock().getRelative(BlockFace.DOWN, h2);
            for (int w = -this.width; w <= this.width; ++w) {
                Block add2 = add.getRelative(right, w);
                targets.add(BukkitAdapter.adapt(add2.getLocation()));
            }
        }
        return targets;
    }

    public static BlockFace getLeft(float yaw) {
        if (yaw == -4.0f || yaw == 0.0f || yaw == 4.0f) {
            return BlockFace.EAST;
        }
        if (yaw == -1.0f || yaw == 3.0f) {
            return BlockFace.NORTH;
        }
        if (yaw == -2.0f || yaw == 2.0f) {
            return BlockFace.WEST;
        }
        if (yaw == -3.0f || yaw == 1.0f) {
            return BlockFace.SOUTH;
        }
        return null;
    }

    public static BlockFace getRight(float yaw) {
        if (yaw == -4.0f || yaw == 0.0f || yaw == 4.0f) {
            return BlockFace.WEST;
        }
        if (yaw == -1.0f || yaw == 3.0f) {
            return BlockFace.SOUTH;
        }
        if (yaw == -2.0f || yaw == 2.0f) {
            return BlockFace.EAST;
        }
        if (yaw == -3.0f || yaw == 1.0f) {
            return BlockFace.NORTH;
        }
        return null;
    }
}

