/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.targeters;

import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.targeters.ILocationSelector;
import io.lumine.xikage.mythicmobs.util.annotations.MythicTargeter;
import java.util.Collection;
import java.util.HashSet;

@MythicTargeter(author="Ashijin", name="forward", aliases={}, description="Targets a point in front of the caster")
public class ForwardTargeter
extends ILocationSelector {
    protected double forward;
    protected float rotate;
    protected boolean useEyeLocation;
    protected boolean rotated = false;

    public ForwardTargeter(MythicLineConfig mlc) {
        super(mlc);
        this.forward = mlc.getDouble(new String[]{"forward", "f", "amount", "a"}, 5.0);
        this.rotate = mlc.getFloat(new String[]{"rotate", "rot"}, 0.0f);
        this.useEyeLocation = mlc.getBoolean(new String[]{"useeyelocation", "uel"}, false);
    }

    @Override
    public Collection<AbstractLocation> getLocations(SkillMetadata data) {
        SkillCaster am = data.getCaster();
        HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
        AbstractLocation location = this.useEyeLocation ? am.getEntity().getEyeLocation() : am.getEntity().getLocation();
        if (this.rotate != 0.0f) {
            location.add(location.getDirection().rotate(this.rotate).normalize().multiply(this.forward));
        } else {
            location.add(location.getDirection().normalize().multiply(this.forward));
        }
        targets.add(this.mutate(data, location));
        return targets;
    }
}

