/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.targeters;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.targeters.ILocationSelector;
import io.lumine.xikage.mythicmobs.util.annotations.MythicTargeter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;

@MythicTargeter(author="Ashijin", name="blocksinchunk", aliases={}, description="Targets all blocks in the targeted chunk")
public class BlocksInChunkTargeter
extends ILocationSelector {
    protected boolean origin = false;
    private MaskType maskType;

    public BlocksInChunkTargeter(MythicLineConfig mlc) {
        super(mlc);
        boolean noAir = mlc.getBoolean(new String[]{"noair", "na"}, true);
        boolean onlyAir = mlc.getBoolean(new String[]{"onlyair", "oa"}, false);
        this.origin = mlc.getBoolean(new String[]{"nearorigin", "no"}, false);
        this.maskType = noAir && !onlyAir ? MaskType.IGNORE_AIR : (onlyAir ? MaskType.ONLY_AIR : MaskType.ALL);
    }

    @Override
    public Collection<AbstractLocation> getLocations(SkillMetadata data) {
        SkillCaster am = data.getCaster();
        HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "@BlocksInChunk targeter", new Object[0]);
        if (this.origin) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "@BlocksInChunk targeter from Origin", new Object[0]);
            for (AbstractLocation location : this.getBlocksInRadius(data, data.getOrigin())) {
                targets.add(location);
            }
        } else if (data.getEntityTargets() != null && !data.getEntityTargets().isEmpty()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "@BlocksInChunk targeter from Entities", new Object[0]);
            for (AbstractEntity e : data.getEntityTargets()) {
                AbstractLocation l = e.getLocation();
                for (AbstractLocation location : this.getBlocksInRadius(data, l)) {
                    targets.add(location);
                }
            }
        } else if (data.getLocationTargets() != null && !data.getLocationTargets().isEmpty()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "@BlocksInChunk targeter from Locations", new Object[0]);
            for (AbstractLocation l : data.getLocationTargets()) {
                for (AbstractLocation location : this.getBlocksInRadius(data, l)) {
                    targets.add(location);
                }
            }
        } else {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "@BlocksInChunk has no inherited targets", new Object[0]);
        }
        return targets;
    }

    private List<AbstractLocation> getBlocksInRadius(SkillMetadata data, AbstractLocation origin) {
        ArrayList<AbstractLocation> blocks = new ArrayList<AbstractLocation>();
        Location o = BukkitAdapter.adapt(origin);
        Chunk chunk = o.getChunk();
        int minX = chunk.getX() << 4;
        int minZ = chunk.getZ() << 4;
        int maxX = minX | 0xF;
        int maxY = chunk.getWorld().getMaxHeight();
        int maxZ = minZ | 0xF;
        for (int x = minX; x <= maxX; ++x) {
            for (int y = 0; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    AbstractLocation newloc = new AbstractLocation(origin.getWorld(), x, y, z);
                    if (this.maskType == MaskType.ALL) {
                        blocks.add(newloc);
                        continue;
                    }
                    if (this.maskType == MaskType.IGNORE_AIR && BukkitAdapter.adapt(newloc).getBlock().getType() != Material.AIR) {
                        blocks.add(newloc);
                        continue;
                    }
                    if (this.maskType != MaskType.ONLY_AIR || BukkitAdapter.adapt(newloc).getBlock().getType() != Material.AIR) continue;
                    blocks.add(newloc);
                }
            }
        }
        return blocks;
    }

    private static enum MaskType {
        ALL,
        IGNORE_AIR,
        ONLY_AIR;

    }
}

