/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.projectiles;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractVector;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.items.MythicItem;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.IParentSkill;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderInt;
import io.lumine.xikage.mythicmobs.skills.variables.VariableRegistry;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.utils.Events;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.items.ItemFactory;
import io.lumine.xikage.mythicmobs.utils.promise.Promise;
import io.lumine.xikage.mythicmobs.utils.terminable.Terminable;
import io.lumine.xikage.mythicmobs.utils.terminable.TerminableRegistry;
import io.lumine.xikage.mythicmobs.utils.version.MinecraftVersions;
import io.lumine.xikage.mythicmobs.utils.version.ServerVersion;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.EulerAngle;

public abstract class Projectile
extends SkillMechanic {
    public static final Set<AbstractEntity> BULLET_ENTITIES = ConcurrentHashMap.newKeySet();
    protected Optional<Skill> onTickSkill = Optional.empty();
    protected Optional<Skill> onHitSkill = Optional.empty();
    protected Optional<Skill> onEndSkill = Optional.empty();
    protected Optional<Skill> onStartSkill = Optional.empty();
    protected String onTickSkillName;
    protected String onHitSkillName;
    protected String onEndSkillName;
    protected String onStartSkillName;
    protected ProjectileType type;
    protected boolean fromOrigin;
    protected BulletType bulletType;
    protected Material bulletMaterial = null;
    protected int bulletModelId = 0;
    protected MythicItem bulletMythicItem = null;
    protected Projectile bulletProjectile = null;
    protected MythicMob bulletMob = null;
    protected float bulletSpin = 0.0f;
    protected boolean bulletMatchDirection = false;
    protected PlaceholderInt duration;
    protected int tickInterval;
    protected float ticksPerSecond;
    protected float hitRadius;
    protected float verticalHitRadius;
    protected float maxDistanceSquared;
    protected float startYOffset;
    protected float startForwardOffset;
    protected float startSideOffset;
    protected float endSideOffset;
    protected float targetYOffset;
    protected float projectileVelocity;
    protected float projectileVelocityVertOffset;
    protected float projectileVelocityHorizOffset;
    protected float projectileVelocityAccuracy;
    protected float projectileVelocityVertNoise;
    protected float projectileVelocityHorizNoise;
    protected float projectileVelocityVertNoiseBase;
    protected float projectileVelocityHorizNoiseBase;
    protected boolean stopOnHitEntity;
    protected boolean stopOnHitGround;
    protected boolean powerAffectsVelocity = true;
    protected boolean powerAffectsRange = true;
    protected boolean hitSelf = false;
    protected boolean hitTarget = true;
    protected boolean hitPlayers = true;
    protected boolean hitNonPlayers = false;
    protected boolean hitTargetOnly = false;
    protected String hitConditionString;
    @MythicField(name="hitConditions", aliases={"conditions", "cond", "c"}, defValue="NONE", version="4.9", premium=true, description="Conditions applied to the hit target")
    protected List<SkillCondition> hitConditions = null;

    public Projectile(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.onTickSkillName = mlc.getString(new String[]{"ontickskill", "ontick", "ot", "skill", "s", "meta", "m"});
        this.onHitSkillName = mlc.getString(new String[]{"onhitskill", "onhit", "oh"});
        this.onEndSkillName = mlc.getString(new String[]{"onendskill", "onend", "oe"});
        this.onStartSkillName = mlc.getString(new String[]{"onstartskill", "onstart", "os"});
        String type = mlc.getString("type", "NORMAL");
        try {
            this.type = ProjectileType.valueOf(type.toUpperCase());
        }
        catch (Exception ex) {
            MythicLogger.errorMechanicConfig(this, mlc, "Invalid projectile type specified");
            this.type = ProjectileType.NORMAL;
        }
        String bulletType = mlc.getString(new String[]{"bullettype", "bullet", "b"}, "NONE", new String[0]);
        try {
            this.bulletType = BulletType.valueOf(bulletType.toUpperCase());
        }
        catch (Exception ex) {
            MythicLogger.errorMechanicConfig(this, mlc, "Invalid bullet type specified");
            this.bulletType = BulletType.NONE;
        }
        switch (this.bulletType) {
            case BLOCK: 
            case ITEM: 
            case SMALLBLOCK: {
                String strBulletMaterial = mlc.getString(new String[]{"bulletmaterial", "material", "mat"}, "STONE", new String[0]);
                try {
                    this.bulletMaterial = Material.valueOf((String)strBulletMaterial.toUpperCase());
                    this.bulletModelId = mlc.getInteger(new String[]{"bulletmodel", "model"}, 0);
                }
                catch (Exception ex) {
                    MythicLogger.errorMechanicConfig(this, mlc, "Specified bullet material does not exist");
                    this.bulletMaterial = Material.STONE;
                }
                break;
            }
            case MYTHICITEM: {
                String strMythicItem = mlc.getString(new String[]{"bulletmaterial", "material", "mat"}, "STONE", new String[0]);
                Optional<MythicItem> maybeItem = MythicMobs.inst().getItemManager().getItem(strMythicItem);
                maybeItem.ifPresent(mythicItem -> {
                    this.bulletMythicItem = mythicItem;
                });
                break;
            }
            case MOB: {
                this.bulletMatchDirection = mlc.getBoolean(new String[]{"bulletmatchdirection", "bmd"}, false);
                break;
            }
        }
        this.bulletSpin = mlc.getFloat(new String[]{"bulletspin", "bspin"}, 0.0f);
        this.tickInterval = mlc.getInteger(new String[]{"interval", "int", "i"}, 4);
        this.ticksPerSecond = 20.0f / (float)this.tickInterval;
        this.hitRadius = mlc.getFloat(new String[]{"horizontalradius", "hradius", "hr", "r"}, 1.25f);
        this.duration = mlc.getPlaceholderInteger(new String[]{"maxduration", "maxduration", "md", "d"}, 400, new String[0]);
        float range = mlc.getFloat(new String[]{"maxrange", "mr"}, 40.0f);
        this.maxDistanceSquared = range * range;
        this.verticalHitRadius = mlc.getFloat(new String[]{"verticalradius", "vradius", "vr"}, this.hitRadius);
        this.startYOffset = mlc.getFloat(new String[]{"startyoffset", "syo"}, 1.0f);
        this.startForwardOffset = mlc.getFloat(new String[]{"forwardoffset", "startfoffset", "sfo", "fo"}, 1.0f) * -1.0f;
        this.targetYOffset = mlc.getFloat(new String[]{"targetyoffset", "targety", "tyo"}, 0.0f);
        float sideOffset = mlc.getFloat(new String[]{"sideoffset", "soffset", "so"}, 0.0f);
        this.startSideOffset = mlc.getFloat(new String[]{"startsideoffset", "ssoffset", "sso"}, sideOffset);
        this.endSideOffset = mlc.getFloat(new String[]{"endoffset", "esoffset", "eso"}, sideOffset);
        this.projectileVelocity = mlc.getFloat(new String[]{"velocity", "v"}, 5.0f);
        this.projectileVelocityVertOffset = mlc.getFloat(new String[]{"verticaloffset", "vo"}, 0.0f);
        this.projectileVelocityHorizOffset = mlc.getFloat(new String[]{"horizontaloffset", "ho"}, 0.0f);
        this.projectileVelocityAccuracy = mlc.getFloat(new String[]{"accuracy", "ac", "a"}, 1.0f);
        float defNoise = (1.0f - this.projectileVelocityAccuracy) * 45.0f;
        this.projectileVelocityVertNoise = mlc.getFloat(new String[]{"verticalnoise", "vn"}, defNoise) / 10.0f;
        this.projectileVelocityHorizNoise = mlc.getFloat(new String[]{"horizontalnoise", "hn"}, defNoise);
        this.projectileVelocityVertNoiseBase = 0.0f - this.projectileVelocityVertNoise / 2.0f;
        this.projectileVelocityHorizNoiseBase = 0.0f - this.projectileVelocityHorizNoise / 2.0f;
        this.stopOnHitEntity = mlc.getBoolean(new String[]{"stopatentity", "se"}, true);
        this.stopOnHitGround = mlc.getBoolean(new String[]{"stopatblock", "sb"}, true);
        this.powerAffectsVelocity = mlc.getBoolean(new String[]{"poweraffectsvelocity", "pav"}, true);
        this.powerAffectsRange = mlc.getBoolean(new String[]{"poweraffectsrange", "par"}, true);
        this.hitSelf = mlc.getBoolean(new String[]{"hitself"}, false);
        this.hitPlayers = mlc.getBoolean(new String[]{"hitplayers", "hp"}, true);
        this.hitNonPlayers = mlc.getBoolean(new String[]{"hitnonplayers", "hnp"}, false);
        this.hitTarget = mlc.getBoolean(new String[]{"hittarget", "ht"}, true);
        this.hitTargetOnly = mlc.getBoolean(new String[]{"hittargetonly", "hto"}, false);
        this.hitConditionString = mlc.getString(new String[]{"hitconditions", "conditions", "cond", "c"}, "null", new String[0]);
        this.fromOrigin = mlc.getBoolean(new String[]{"fromorigin", "fo"}, false);
        Projectile.getPlugin().getSkillManager().queueSecondPass(() -> {
            if (this.onTickSkillName != null) {
                this.onTickSkill = Projectile.getPlugin().getSkillManager().getSkill(this.onTickSkillName);
            }
            if (this.onHitSkillName != null) {
                this.onHitSkill = Projectile.getPlugin().getSkillManager().getSkill(this.onHitSkillName);
            }
            if (this.onEndSkillName != null) {
                this.onEndSkill = Projectile.getPlugin().getSkillManager().getSkill(this.onEndSkillName);
            }
            if (this.onStartSkillName != null) {
                this.onStartSkill = Projectile.getPlugin().getSkillManager().getSkill(this.onStartSkillName);
            }
            if (this.bulletType == BulletType.MOB) {
                String mobType = mlc.getString(new String[]{"mob", "mobtype", "mm"}, "SkeletalKnight", new String[0]);
                this.bulletMob = Projectile.getPlugin().getMobManager().getMythicMob(mobType);
                if (this.bulletMob == null) {
                    MythicLogger.errorMechanicConfig(this, mlc, "Invalid bullet mob type specified");
                    this.bulletType = BulletType.NONE;
                }
            }
            if (this.hitConditionString != null && MythicMobs.isVolatile()) {
                this.hitConditions = Projectile.getPlugin().getSkillManager().getConditions(this.hitConditionString);
            }
        });
    }

    public float getTargetYOffset() {
        return this.targetYOffset;
    }

    protected static enum ProjectileType {
        NORMAL,
        METEOR;

    }

    protected static enum BulletType {
        NONE,
        ITEM,
        BLOCK,
        SMALLBLOCK,
        MYTHICITEM,
        ARMOR_STAND,
        ARROW,
        MOB;

    }

    public abstract class ProjectileTracker
    implements IParentSkill,
    Runnable,
    Terminable {
        protected final TerminableRegistry components = TerminableRegistry.create();
        protected SkillMetadata data;
        protected int chargesRemaining;
        protected int ticksRemaining;
        protected AbstractEntity bullet = null;
        protected float power;
        protected AbstractLocation startLocation;
        protected AbstractLocation previousLocation;
        protected AbstractLocation currentLocation;
        protected AbstractVector currentVelocity;
        protected Set<AbstractEntity> inRange = ConcurrentHashMap.newKeySet();
        protected HashSet<AbstractEntity> targets = new HashSet();
        protected HashMap<AbstractEntity, Long> immune = new HashMap();

        public ProjectileTracker(SkillMetadata data, AbstractLocation target) {
            this.data = data.deepClone();
            this.data.setCallingEvent(this);
            this.data.setIsAsync(true);
            this.power = data.getPower();
            this.ticksRemaining = Projectile.this.duration.get(data);
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "++ Projectile fired by Entity {0}: skill = {1}", data.getCaster().getEntity().getName(), Projectile.this.line);
        }

        private void evaluatePotentialTargets() {
            this.inRange.clear();
            if (Projectile.this.hitSelf || Projectile.this.hitPlayers || Projectile.this.hitNonPlayers) {
                this.inRange.addAll(AbstractSkill.getPlugin().getVolatileCodeHandler().getWorldHandler().getEntitiesNearLocation(this.currentLocation, Projectile.this.hitRadius));
                this.inRange.removeIf(e -> {
                    if (e == null) {
                        return true;
                    }
                    if (!e.isLiving() || e.isCitizensNPC()) {
                        return true;
                    }
                    if (!Projectile.this.hitSelf && e.getUniqueId().equals(this.data.getCaster().getEntity().getUniqueId())) {
                        return true;
                    }
                    if (!Projectile.this.hitPlayers && e.isPlayer()) {
                        return true;
                    }
                    if (!Projectile.this.hitNonPlayers && !e.isPlayer()) {
                        return true;
                    }
                    if (this.bullet != null && this.bullet.getUniqueId().equals(e.getUniqueId())) {
                        return true;
                    }
                    if (Projectile.this.hitConditions != null) {
                        for (SkillCondition condition : Projectile.this.hitConditions) {
                            if (condition.evaluateEntity((AbstractEntity)e)) continue;
                            return true;
                        }
                    }
                    return false;
                });
            }
        }

        public boolean executeProjectileSkill(Optional<Skill> skill, SkillMetadata data, boolean atCaster) {
            if (skill == null) {
                return true;
            }
            if (!skill.isPresent()) {
                return true;
            }
            data = data.deepClone();
            if (atCaster) {
                data.setEntityTarget(data.getCaster().getEntity());
            }
            if (skill.get().isUsable(data)) {
                VariableRegistry vars = data.getVariables();
                skill.get().execute(data);
                return true;
            }
            return false;
        }

        public void setPower(float p) {
            this.power = p;
        }

        public void modifyPower(float p) {
            this.power *= p;
        }

        public BoundingBox getBoundingBox() {
            return BoundingBox.of((Location)BukkitAdapter.adapt(this.currentLocation), (double)Projectile.this.hitRadius, (double)Projectile.this.verticalHitRadius, (double)Projectile.this.hitRadius);
        }

        public boolean start() {
            this.components.accept(Events.subscribe(WorldUnloadEvent.class).filter(event -> event.getWorld().getUID().equals(this.startLocation.getWorld().getUniqueId())).handler(event -> this.terminate()));
            Promise.start().thenRunSync(() -> {
                this.projectileStart();
                if (Projectile.this.bulletType != BulletType.NONE) {
                    this.spawnBullet();
                    if (Projectile.this.bulletType == BulletType.BLOCK) {
                        this.components.accept(Events.subscribe(EntityChangeBlockEvent.class).filter(event -> event.getEntity().getUniqueId().equals(this.bullet.getUniqueId())).handler(event -> event.setCancelled(true)));
                    } else if (Projectile.this.bulletType == BulletType.MOB || Projectile.this.bulletType == BulletType.ARMOR_STAND) {
                        this.components.accept(Events.subscribe(PlayerInteractEntityEvent.class).filter(event -> event.getRightClicked() != null).filter(event -> event.getRightClicked().getUniqueId().equals(this.bullet.getUniqueId())).handler(event -> event.setCancelled(true)));
                    } else if (Projectile.this.bulletType == BulletType.ARROW) {
                        this.components.accept(Events.subscribe(EntityDamageByEntityEvent.class).filter(event -> this.bullet != null).filter(event -> event.getDamager() != null).filter(event -> event.getDamager().getUniqueId().equals(this.bullet.getUniqueId())).handler(event -> event.setCancelled(true)));
                    }
                }
                if (Projectile.this.onStartSkill.isPresent() && Projectile.this.onStartSkill.get().isUsable(this.data)) {
                    SkillMetadata sData = this.data.deepClone();
                    HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
                    targets.add(this.startLocation);
                    sData.setLocationTargets(targets);
                    sData.setOrigin(this.currentLocation.clone());
                    Projectile.this.onStartSkill.get().execute(sData);
                }
                this.run();
                this.components.accept(Schedulers.sync().runRepeating(this, 0L, (long)Projectile.this.tickInterval));
            });
            return true;
        }

        @Override
        public void run() {
            this.ticksRemaining -= Projectile.this.tickInterval;
            if (this.data.getCaster() != null && this.data.getCaster().getEntity().isDead()) {
                this.terminate();
                return;
            }
            if (this.currentLocation.distanceSquared(this.startLocation) >= (double)Projectile.this.maxDistanceSquared) {
                this.terminate();
                return;
            }
            if (this.ticksRemaining <= 0) {
                this.terminate();
                return;
            }
            this.evaluatePotentialTargets();
            this.projectileTick();
        }

        public abstract void projectileStart();

        public abstract void projectileTick();

        public void projectileEnd() {
        }

        @Override
        public void close() {
            if (!this.components.hasTerminated()) {
                this.projectileEnd();
                if (Projectile.this.bulletType != BulletType.NONE) {
                    Schedulers.sync().runLater(() -> {
                        if (this.bullet != null) {
                            this.bullet.remove();
                            BULLET_ENTITIES.remove(this.bullet);
                        }
                    }, 2L);
                }
                if (Projectile.this.onEndSkill.isPresent() && Projectile.this.onEndSkill.get().isUsable(this.data)) {
                    SkillMetadata sData = this.data.deepClone();
                    Projectile.this.onEndSkill.get().execute(sData.setOrigin(this.currentLocation).setLocationTarget(this.currentLocation));
                }
                if (this.inRange != null) {
                    this.inRange.clear();
                }
            }
            this.components.closeAndReportException();
        }

        @Override
        public void setCancelled() {
            this.terminate();
        }

        @Override
        public boolean getCancelled() {
            return this.components.hasTerminated();
        }

        private void spawnBullet() {
            if (Projectile.this.bulletType == BulletType.ARMOR_STAND) {
                ArmorStand armorStand;
                if (this.hasTerminated()) {
                    return;
                }
                AbstractLocation l = this.currentLocation.clone().subtract(0.0, 0.5, 0.0);
                Location location = BukkitAdapter.adapt(l);
                if (ServerVersion.isPaper() && ServerVersion.isAfterOrEq(MinecraftVersions.v1_13)) {
                    armorStand = (ArmorStand)location.getWorld().spawnEntity(location, EntityType.ARMOR_STAND, CreatureSpawnEvent.SpawnReason.CUSTOM, entity -> {
                        ArmorStand as = (ArmorStand)entity;
                        as.setAI(true);
                        as.setTicksLived(Integer.MAX_VALUE);
                        as.setInvulnerable(true);
                        as.setGravity(false);
                    });
                } else {
                    armorStand = (ArmorStand)MythicMobs.inst().getVolatileCodeHandler().getWorldHandler().spawnInvisibleArmorStand(location);
                    armorStand.setInvisible(true);
                    armorStand.setAI(true);
                    armorStand.setTicksLived(Integer.MAX_VALUE);
                    armorStand.setInvulnerable(true);
                    armorStand.setGravity(false);
                }
                this.bullet = BukkitAdapter.adapt((Entity)armorStand);
                BULLET_ENTITIES.add(this.bullet);
                AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().setHitBox(this.bullet, 0.0, 0.0, 0.0);
                if (this.hasTerminated()) {
                    armorStand.remove();
                }
            } else if (Projectile.this.bulletType == BulletType.BLOCK) {
                if (this.hasTerminated()) {
                    return;
                }
                AbstractLocation l = this.currentLocation.clone().subtract(0.0, 0.5, 0.0);
                FallingBlock block = ServerVersion.isAfterOrEq(MinecraftVersions.v1_15) ? BukkitAdapter.adapt(l).getWorld().spawnFallingBlock(BukkitAdapter.adapt(l), Projectile.this.bulletMaterial.createBlockData()) : BukkitAdapter.adapt(l).getWorld().spawnFallingBlock(BukkitAdapter.adapt(l), Projectile.this.bulletMaterial, (byte)0);
                block.setHurtEntities(false);
                block.setDropItem(false);
                block.setTicksLived(Integer.MAX_VALUE);
                block.setInvulnerable(true);
                block.setGravity(false);
                this.bullet = BukkitAdapter.adapt((Entity)block);
                BULLET_ENTITIES.add(this.bullet);
                AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().setHitBox(this.bullet, 0.0, 0.0, 0.0);
                if (this.hasTerminated()) {
                    block.remove();
                }
            } else if (Projectile.this.bulletType == BulletType.MYTHICITEM) {
                ItemStack i = BukkitAdapter.adapt(Projectile.this.bulletMythicItem.generateItemStack(1));
                AbstractLocation l = this.currentLocation.clone().subtract(0.0, 0.35, 0.0);
                Item item = BukkitAdapter.adapt(l).getWorld().dropItem(BukkitAdapter.adapt(l), i);
                item.setTicksLived(Integer.MAX_VALUE);
                item.setInvulnerable(true);
                item.setGravity(false);
                item.setPickupDelay(Integer.MAX_VALUE);
                this.bullet = BukkitAdapter.adapt((Entity)item);
                BULLET_ENTITIES.add(this.bullet);
                AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().setItemPosition(this.bullet, l);
                AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().sendEntityTeleportPacket(this.bullet);
                AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().setHitBox(this.bullet, 0.0, 0.0, 0.0);
                if (this.hasTerminated()) {
                    item.remove();
                }
            } else if (Projectile.this.bulletType == BulletType.SMALLBLOCK) {
                AbstractLocation l = this.currentLocation.clone();
                ArmorStand block = (ArmorStand)BukkitAdapter.adapt(l).getWorld().spawnEntity(BukkitAdapter.adapt(l), EntityType.ARMOR_STAND);
                block.setCustomName("Dinnerbone");
                block.setCustomNameVisible(false);
                block.setHeadPose(new EulerAngle(0.0, 0.0, 0.0));
                block.getEquipment().setHelmet(new ItemStack(Projectile.this.bulletMaterial));
                block.setArms(false);
                block.setBasePlate(false);
                block.setVisible(false);
                block.setTicksLived(Integer.MAX_VALUE);
                block.setInvulnerable(true);
                this.bullet = BukkitAdapter.adapt((Entity)block);
                AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().setArmorStandNoGravity(this.bullet);
                BULLET_ENTITIES.add(this.bullet);
                AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().setHitBox(this.bullet, 0.0, 0.0, 0.0);
                if (this.hasTerminated()) {
                    block.remove();
                }
            } else if (Projectile.this.bulletType == BulletType.ITEM) {
                ItemStack i = ItemFactory.of(Projectile.this.bulletMaterial).model(Projectile.this.bulletModelId).build();
                AbstractLocation l = this.currentLocation.clone().subtract(0.0, 0.35, 0.0);
                Item item = BukkitAdapter.adapt(l).getWorld().dropItem(BukkitAdapter.adapt(l), i);
                item.setTicksLived(Integer.MAX_VALUE);
                item.setInvulnerable(true);
                item.setGravity(false);
                item.setPickupDelay(Integer.MAX_VALUE);
                this.bullet = BukkitAdapter.adapt((Entity)item);
                BULLET_ENTITIES.add(this.bullet);
                AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().setItemPosition(this.bullet, l);
                AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().sendEntityTeleportPacket(this.bullet);
                AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().setHitBox(this.bullet, 0.0, 0.0, 0.0);
                if (this.hasTerminated()) {
                    item.remove();
                }
            } else if (Projectile.this.bulletType == BulletType.MOB && Projectile.this.bulletMob != null) {
                AbstractLocation l = this.previousLocation.clone().subtract(0.0, 1.35, 0.0);
                ActiveMob am = Projectile.this.bulletMob.spawn(l, 1.0, SpawnReason.OTHER, entity -> {
                    entity.setTicksLived(Integer.MAX_VALUE);
                    entity.setInvulnerable(true);
                    entity.setVelocity(BukkitAdapter.adapt(this.currentVelocity));
                    if (entity.getType().equals((Object)EntityType.ARMOR_STAND)) {
                        AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().setArmorStandNoGravity(BukkitAdapter.adapt(entity));
                        ((ArmorStand)entity).setAI(true);
                        ((ArmorStand)entity).setRemoveWhenFarAway(true);
                    } else {
                        entity.setGravity(false);
                        if (entity instanceof LivingEntity) {
                            ((LivingEntity)entity).setRemoveWhenFarAway(true);
                        }
                    }
                });
                Entity entity2 = am.getEntity().getBukkitEntity();
                am.setParent(this.data.getCaster());
                am.setOwner(this.data.getCaster().getEntity().getUniqueId());
                this.bullet = BukkitAdapter.adapt(entity2);
                BULLET_ENTITIES.add(this.bullet);
                AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().setHitBox(this.bullet, 0.0, 0.0, 0.0);
                if (this.hasTerminated()) {
                    this.bullet.remove();
                }
                this.bullet.teleport(this.currentLocation.clone().subtract(0.0, 1.35, 0.0));
            } else if (Projectile.this.bulletType == BulletType.ARROW) {
                AbstractLocation l = this.currentLocation.clone();
                Location loc = BukkitAdapter.adapt(l);
                Arrow arrow = (Arrow)loc.getWorld().spawn(loc, Arrow.class);
                arrow.setTicksLived(Integer.MAX_VALUE);
                arrow.setInvulnerable(true);
                arrow.setGravity(false);
                arrow.setVelocity(BukkitAdapter.adapt(this.currentVelocity).multiply(0.25));
                this.bullet = BukkitAdapter.adapt((Entity)arrow);
                BULLET_ENTITIES.add(this.bullet);
                AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().setHitBox(this.bullet, 0.0, 0.0, 0.0);
                if (this.hasTerminated()) {
                    arrow.remove();
                }
            }
            if (this.bullet != null) {
                this.applyBulletVelocity();
            }
        }

        public abstract void applyBulletVelocity();

        public int getChargesRemaining() {
            return this.chargesRemaining;
        }

        public int getTicksRemaining() {
            return this.ticksRemaining;
        }
    }
}

