/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.INoTargetSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="weather", description="Changes the weather")
public class WeatherMechanic
extends SkillMechanic
implements INoTargetSkill {
    int type;
    int duration;

    public WeatherMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        String t = mlc.getString("type", "sunny");
        this.duration = mlc.getInteger("duration", 500);
        switch (t) {
            case "sunny": 
            case "sun": 
            case "clear": {
                this.type = 0;
                break;
            }
            case "rain": 
            case "rainy": {
                this.type = 1;
                break;
            }
            case "stormy": 
            case "storm": 
            case "thunder": {
                this.type = 2;
                break;
            }
            default: {
                this.type = 0;
            }
        }
    }

    @Override
    public boolean cast(SkillMetadata data) {
        switch (this.type) {
            case 0: {
                data.getCaster().getEntity().getWorld().setStorm(false);
                break;
            }
            case 1: {
                data.getCaster().getEntity().getWorld().setStorm(true);
                data.getCaster().getEntity().getWorld().setThundering(false);
                break;
            }
            case 2: {
                data.getCaster().getEntity().getWorld().setStorm(true);
                data.getCaster().getEntity().getWorld().setThundering(true);
            }
        }
        data.getCaster().getEntity().getWorld().setWeatherDuration(this.duration);
        return true;
    }
}

