/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Fox;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Wolf;

@MythicMechanic(author="Joshinn", name="togglesitting", aliases={"sit"}, description="Toggles the sitting state of an entity for cats/dogs.")
public class ToggleSittingMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    private boolean option;

    public ToggleSittingMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.option = mlc.getBoolean(new String[]{"setSitting", "state"}, false);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        LivingEntity entity = (LivingEntity)BukkitAdapter.adapt(target);
        switch (entity.getType()) {
            case WOLF: {
                ((Wolf)entity).setSitting(this.option);
                break;
            }
            case CAT: {
                ((Cat)entity).setSitting(this.option);
                break;
            }
            case FOX: {
                ((Fox)entity).setSitting(this.option);
                break;
            }
            case PARROT: {
                ((Parrot)entity).setSitting(this.option);
                break;
            }
            default: {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "This animal cannot sit.", new Object[0]);
                return false;
            }
        }
        return true;
    }
}

