/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MobManager;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="teleport", aliases={"tp"}, description="Teleports to the target location")
public class TeleportMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected double spreadH;
    protected double spreadV;

    public TeleportMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.spreadH = mlc.getDouble(new String[]{"spreadh", "sh"}, 0.0);
        this.spreadV = mlc.getDouble(new String[]{"spreadv", "sv"}, 0.0);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (data.getCaster() instanceof ActiveMob) {
            ActiveMob am = (ActiveMob)data.getCaster();
            AbstractEntity abstractEntity = am.getEntity();
            TeleportMechanic.getPlugin().getMobManager();
            abstractEntity.teleport(MobManager.findSafeSpawnLocation(target.getLocation(), (int)this.spreadH, (int)this.spreadV, am.getType().getMythicEntity().getHeight() + 1));
        } else {
            AbstractEntity abstractEntity = data.getCaster().getEntity();
            TeleportMechanic.getPlugin().getMobManager();
            abstractEntity.teleport(MobManager.findSafeSpawnLocation(target.getLocation(), (int)this.spreadH, (int)this.spreadV, 2));
        }
        return true;
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        if (this.spreadH > 0.0 || this.spreadV > 0.0) {
            if (data.getCaster() instanceof ActiveMob) {
                ActiveMob am = (ActiveMob)data.getCaster();
                TeleportMechanic.getPlugin().getMobManager();
                target = MobManager.findSafeSpawnLocation(target, (int)this.spreadH, (int)this.spreadV, am.getType().getMythicEntity().getHeight() + 1);
            } else {
                TeleportMechanic.getPlugin().getMobManager();
                target = MobManager.findSafeSpawnLocation(target, (int)this.spreadH, (int)this.spreadV, 2);
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Teleporting to {0}", target.toString());
        data.getCaster().getEntity().teleport(target);
        return true;
    }
}

