/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.INoTargetSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;

public class SummonPassengerMechanic
extends SkillMechanic
implements INoTargetSkill {
    protected MythicMob mount;
    protected String strType;

    public SummonPassengerMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.strType = mlc.getString(new String[]{"passenger", "p", "rider", "r", "type", "t"});
        this.mount = MythicMobs.inst().getMobManager().getMythicMob(this.strType);
    }

    @Override
    public boolean cast(SkillMetadata data) {
        AbstractEntity me;
        if (this.mount == null) {
            this.mount = MythicMobs.inst().getMobManager().getMythicMob(this.strType);
            if (this.mount == null) {
                MythicLogger.errorMechanicConfig(this, this.config, "The 'mob' attribute must be a valid MythicMob.");
                return false;
            }
        }
        if ((me = this.mount.spawn(data.getCaster().getEntity().getLocation(), data.getCaster().getLevel(), SpawnReason.SUMMON).getEntity()) == null) {
            return false;
        }
        data.getCaster().getEntity().setPassenger(me);
        MythicMobs.inst().getMobManager().getActiveMob(me.getUniqueId()).get().setOwner(data.getCaster().getEntity().getUniqueId());
        return true;
    }
}

