/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MobManager;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderDouble;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderInt;

public class SummonMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected MythicMob mm;
    protected BukkitEntityType me;
    protected String strType;
    protected PlaceholderInt amount;
    protected PlaceholderDouble level;
    protected int noise;
    protected int yNoise;
    protected boolean summonerIsOwner;
    protected boolean summonerIsParent;
    protected boolean summonerIsFaction;
    protected boolean yUpOnly;
    protected boolean onSurface;
    protected boolean inheritFaction;
    protected boolean inheritThreatTable;
    protected boolean copyThreatTable;

    public SummonMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.strType = mlc.getString(new String[]{"type", "t", "mob", "m"}, "SKELETON", new String[0]);
        this.amount = mlc.getPlaceholderInteger(new String[]{"amount", "a"}, 1, new String[0]);
        this.level = mlc.getPlaceholderDouble(new String[]{"level", "l"}, -1.0, new String[0]);
        this.noise = mlc.getInteger(new String[]{"noise", "n", "radius", "r"}, 0);
        this.yNoise = mlc.getInteger(new String[]{"ynoise", "yn", "yradius", "yr"}, this.noise);
        this.yUpOnly = mlc.getBoolean(new String[]{"yradiusuponly", "yradiusonlyup", "yruo", "yu"}, false);
        this.onSurface = mlc.getBoolean(new String[]{"onsurface", "os", "s"}, false);
        this.copyThreatTable = mlc.getBoolean(new String[]{"copythreattable", "ctt"}, false);
        this.inheritFaction = mlc.getBoolean(new String[]{"inheritfaction", "if"}, true);
        this.inheritThreatTable = mlc.getBoolean(new String[]{"inheritthreattable", "itt"}, false);
        this.summonerIsOwner = mlc.getBoolean(new String[]{"summonerisowner", "sio"}, true);
        this.summonerIsParent = mlc.getBoolean(new String[]{"summonerisparent", "sip"}, true);
        this.summonerIsFaction = mlc.getBoolean(new String[]{"summonerisfaction", "sif"}, false);
        SummonMechanic.getPlugin().getSkillManager().queueSecondPass(() -> {
            this.mm = SummonMechanic.getPlugin().getMobManager().getMythicMob(this.strType);
            if (this.mm == null) {
                this.me = BukkitEntityType.getMythicEntity(this.strType);
                if (this.me == null) {
                    MythicLogger.errorMechanicConfig(this, mlc, "The 'type' attribute must be a valid MythicMob or MythicEntity type.");
                }
            }
        });
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        int amount = this.amount.get(data);
        double level = this.level.get(data);
        double d = level = level == -1.0 ? data.getCaster().getLevel() : level;
        if (this.mm != null) {
            if (this.noise > 0) {
                for (int i = 1; i <= amount; ++i) {
                    int height = this.mm.getMythicEntity() == null ? 2 : this.mm.getMythicEntity().getHeight();
                    SummonMechanic.getPlugin().getMobManager();
                    AbstractLocation l = MobManager.findSafeSpawnLocation(target, this.noise, this.yNoise, height, this.yUpOnly, this.onSurface);
                    ActiveMob ams = this.mm.spawn(l, level, SpawnReason.SUMMON);
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Summoning {0} at {1}", this.strType, l.toString());
                    if (ams == null) continue;
                    SummonMechanic.getPlugin().getEntityManager().registerMob(ams.getEntity().getWorld(), ams.getEntity());
                    if (data.getCaster() instanceof ActiveMob) {
                        ActiveMob am = (ActiveMob)data.getCaster();
                        if (this.summonerIsOwner) {
                            ams.setParent(am);
                            ams.setOwner(data.getCaster().getEntity().getUniqueId());
                        }
                        if (this.inheritFaction) {
                            ams.setFaction(am.getFaction());
                        }
                        if (this.copyThreatTable) {
                            try {
                                ams.importThreatTable(am.getThreatTable().clone());
                                ams.getThreatTable().targetHighestThreat();
                            }
                            catch (CloneNotSupportedException e1) {
                                e1.printStackTrace();
                            }
                            continue;
                        }
                        if (!this.inheritThreatTable) continue;
                        ams.importThreatTable(am.getThreatTable());
                        ams.getThreatTable().targetHighestThreat();
                        continue;
                    }
                    if (!this.summonerIsOwner) continue;
                    ams.setOwner(data.getCaster().getEntity().getUniqueId());
                }
            } else {
                for (int i = 1; i <= amount; ++i) {
                    ActiveMob ams = this.mm.spawn(target, level, SpawnReason.SUMMON);
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Summoning {0} at {1}", this.strType, target.toString());
                    if (ams == null) continue;
                    SummonMechanic.getPlugin().getEntityManager().registerMob(ams.getEntity().getWorld(), ams.getEntity());
                    if (data.getCaster() instanceof ActiveMob) {
                        ActiveMob am = (ActiveMob)data.getCaster();
                        if (this.summonerIsOwner) {
                            ams.setParent(am);
                            ams.setOwner(data.getCaster().getEntity().getUniqueId());
                        }
                        if (this.inheritFaction) {
                            ams.setFaction(am.getFaction());
                        }
                        if (this.copyThreatTable) {
                            try {
                                ams.importThreatTable(am.getThreatTable().clone());
                                ams.getThreatTable().targetHighestThreat();
                            }
                            catch (CloneNotSupportedException e1) {
                                e1.printStackTrace();
                            }
                            continue;
                        }
                        if (!this.inheritThreatTable) continue;
                        ams.importThreatTable(am.getThreatTable());
                        ams.getThreatTable().targetHighestThreat();
                        continue;
                    }
                    if (!this.summonerIsOwner) continue;
                    ams.setOwner(data.getCaster().getEntity().getUniqueId());
                }
            }
            return true;
        }
        if (this.me != null) {
            if (this.noise > 0) {
                for (int i = 1; i <= amount; ++i) {
                    SummonMechanic.getPlugin().getMobManager();
                    AbstractLocation l = MobManager.findSafeSpawnLocation(target, this.noise, this.yNoise, this.me.getHeight(), this.yUpOnly, this.onSurface);
                    this.me.spawn(BukkitAdapter.adapt(l), SpawnReason.SUMMON);
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Summoning {0} at {1} with noise", this.strType, l.toString());
                }
            } else {
                for (int i = 1; i <= amount; ++i) {
                    this.me.spawn(BukkitAdapter.adapt(target), SpawnReason.SUMMON);
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Summoning {0} at {1}", this.strType, target.toString());
                }
            }
            return true;
        }
        MythicLogger.error("SummonMechanic: Mob Type {0} not found", this.strType);
        return true;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.castAtLocation(data, target.getLocation());
        return true;
    }
}

