/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.GenericCaster;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillTargeter;
import io.lumine.xikage.mythicmobs.skills.mechanics.MetaSkillMechanic;
import io.lumine.xikage.mythicmobs.skills.targeters.IEntitySelector;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import java.util.Collection;
import java.util.Optional;

@MythicMechanic(author="Ashijin", name="sudoskill", aliases={"sudo"}, description="Forces the inherited target to execute the skill at the targeted entity")
public class SudoSkillMechanic
extends MetaSkillMechanic {
    private boolean casterAsTrigger = false;
    private Optional<SkillTargeter> targetOverride = Optional.empty();

    public SudoSkillMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.casterAsTrigger = mlc.getBoolean(new String[]{"setcasterastrigger", "cat"}, false);
        String strTarget = mlc.getString(new String[]{"target", "t"}, null, new String[0]);
        if (strTarget != null) {
            this.targetOverride = Optional.of(this.parseSkillTargeter(strTarget));
        }
    }

    @Override
    public boolean cast(SkillMetadata data) {
        SkillTargeter targeter;
        Collection<AbstractEntity> targets = data.getEntityTargets();
        if (this.targeter.isPresent() && (targeter = (SkillTargeter)this.targeter.get()) instanceof IEntitySelector) {
            targets = ((IEntitySelector)targeter).getEntities(data);
            ((IEntitySelector)targeter).filter(data, this.targetsCreativePlayers());
        }
        if (targets == null || targets.size() == 0) {
            return false;
        }
        for (AbstractEntity target : targets) {
            SkillCaster caster = MythicMobs.inst().getMobManager().isActiveMob(target) ? MythicMobs.inst().getMobManager().getMythicMobInstance(target) : new GenericCaster(target);
            SkillMetadata newData = data.deepClone();
            if (this.targetOverride.isPresent()) {
                this.evaluateTargets(newData, this.targetOverride.get());
            }
            newData.setCaster(caster);
            if (this.casterAsTrigger) {
                newData.setTrigger(data.getCaster().getEntity());
            }
            if (!this.metaskill.isPresent()) continue;
            Skill ms = (Skill)this.metaskill.get();
            if (ms.isUsable(newData)) {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Executing SudoSkill " + this.skillName, new Object[0]);
                if (this.forceSync) {
                    newData.setIsAsync(false);
                    Schedulers.sync().run(() -> {
                        newData.setIsAsync(false);
                        ms.execute(newData);
                    });
                    continue;
                }
                ms.execute(newData);
                continue;
            }
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Skill is not usable at this time! Cancelling.", new Object[0]);
            return false;
        }
        return true;
    }
}

