/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.auras.Aura;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderInt;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", version="4.8", name="stun", description="Applies an aura that stuns the target entity")
public class StunMechanic
extends Aura
implements ITargetedEntitySkill {
    private boolean stopAI;
    private boolean stopGravity;
    private boolean freezeFacing;

    public StunMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.stopAI = mlc.getBoolean(new String[]{"stopai", "ai"}, false);
        this.stopGravity = mlc.getBoolean(new String[]{"gravity", "g"}, false);
        this.freezeFacing = mlc.getBoolean(new String[]{"facing", "face", "f"}, false);
        this.interval = PlaceholderInt.of("1");
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        new StunMechanicTracker(target, data);
        return true;
    }

    protected class StunMechanicTracker
    extends Aura.AuraTracker {
        private double x;
        private double y;
        private double z;
        private float pitch;
        private float yaw;
        private boolean hadAI;
        private boolean hadGravity;

        public StunMechanicTracker(AbstractEntity target, SkillMetadata data) {
            super((Aura)StunMechanic.this, target, data);
            this.hadAI = false;
            this.hadGravity = false;
            this.x = target.getLocation().getX();
            this.y = target.getLocation().getY();
            this.z = target.getLocation().getZ();
            this.pitch = target.getLocation().getPitch();
            this.yaw = target.getLocation().getYaw();
            this.start();
        }

        @Override
        public void auraStart() {
            if (StunMechanic.this.stopAI && ((AbstractEntity)this.entity.get()).hasAI()) {
                this.hadAI = true;
                ((AbstractEntity)this.entity.get()).setAI(false);
            }
            if (StunMechanic.this.stopGravity && ((AbstractEntity)this.entity.get()).hasGravity()) {
                this.hadGravity = true;
                ((AbstractEntity)this.entity.get()).setGravity(false);
            }
            this.executeAuraSkill(StunMechanic.this.onStartSkill, this.skillMetadata);
        }

        @Override
        public void auraTick() {
            if (((AbstractEntity)this.entity.get()).isOnGround()) {
                if (!StunMechanic.this.freezeFacing) {
                    this.pitch = ((AbstractEntity)this.entity.get()).getLocation().getPitch();
                    this.yaw = ((AbstractEntity)this.entity.get()).getLocation().getYaw();
                }
                AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().setLocation((AbstractEntity)this.entity.get(), this.x, this.y, this.z, this.yaw, this.pitch, StunMechanic.this.freezeFacing, StunMechanic.this.stopGravity);
            }
        }

        @Override
        public void auraStop() {
            if (StunMechanic.this.stopAI && this.hadAI) {
                ((AbstractEntity)this.entity.get()).setAI(true);
            }
            if (StunMechanic.this.stopGravity && this.hadGravity) {
                ((AbstractEntity)this.entity.get()).setGravity(true);
            }
            this.executeAuraSkill(StunMechanic.this.onEndSkill, this.skillMetadata);
        }
    }
}

