/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.holograms.types.SpeechBubble;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.INoTargetSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.auras.Aura;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderInt;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.text.Text;
import java.util.Optional;

@MythicMechanic(author="Ashijin", name="speak", aliases={"speech"}, description="Makes the caster speak using chat and speech bubbles")
public class SpeakMechanic
extends Aura
implements INoTargetSkill,
ITargetedEntitySkill {
    protected PlaceholderString chatMessage;
    protected PlaceholderString bubbleMessage;
    protected float offset;
    protected int radius;
    protected int maxLineLength;
    protected boolean animateWords;
    protected boolean animateLetters;
    protected PlaceholderString linePrefix;

    public SpeakMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.target_creative = true;
        this.auraName = Optional.of("#speaking");
        this.charges = PlaceholderInt.of("1");
        this.maxStacks = PlaceholderInt.of("1");
        this.mergeSameCaster = false;
        this.overwriteCaster = true;
        this.refreshDuration = false;
        this.offset = mlc.getFloat(new String[]{"offset", "o"}, 0.4f);
        this.radius = mlc.getInteger(new String[]{"radius", "r"}, 12);
        this.maxLineLength = mlc.getInteger(new String[]{"maxlinelength", "linelength", "ll", "mll", "ml"}, 22);
        this.linePrefix = mlc.getPlaceholderString(new String[]{"lineprefix", "lp"}, "&f", new String[0]);
        PlaceholderString message = mlc.getPlaceholderString(new String[]{"message", "msg", "m"}, null, new String[0]);
        String chatPrefix = mlc.getString(new String[]{"chatprefix", "cp"}, "<caster.name>&f<&co> ", new String[0]);
        if (message == null) {
            MythicLogger.errorMechanicConfig(this, mlc, "The 'message' attribute is required.");
            this.chatMessage = PlaceholderString.of("INCORRECTLY CONFIGURED. SEE CONSOLE ON RELOAD.");
            this.bubbleMessage = PlaceholderString.of("INCORRECTLY CONFIGURED. SEE CONSOLE ON RELOAD.");
        } else {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Loaded Speak mechanic with message {0}", message.toString());
            this.chatMessage = PlaceholderString.of(chatPrefix + message);
            this.bubbleMessage = message;
        }
        this.duration = mlc.getPlaceholderInteger(new String[]{"ticks", "t", "duration", "d", "time", "t"}, message.toString().length() * 4, new String[0]);
    }

    @Override
    public boolean cast(SkillMetadata data) {
        if (!SpeakMechanic.getPlugin().getHologramManager().isActive()) {
            this.sendChatSpeech(data, this.chatMessage.get(data));
            return false;
        }
        new SpeechTracker(data);
        return true;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!SpeakMechanic.getPlugin().getHologramManager().isActive()) {
            this.sendChatSpeech(data, this.chatMessage.get(data, target));
            return false;
        }
        new SpeechTracker(target, data);
        return true;
    }

    public void sendChatSpeech(SkillMetadata data, String message) {
        for (AbstractPlayer p : MythicMobs.inst().getEntityManager().getPlayers(data.getCaster().getEntity().getWorld())) {
            if (!p.getWorld().equals(data.getCaster().getEntity().getWorld()) || !(data.getCaster().getEntity().getLocation().distanceSquared(p.getLocation()) < Math.pow(this.radius, 2.0))) continue;
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Sending speech to {0}: {1}", p.getName(), message);
            p.sendMessage(message);
        }
    }

    public class SpeechTracker
    extends Aura.AuraTracker {
        private SpeechBubble bubble;
        private String speech;

        public SpeechTracker(SkillMetadata data) {
            super(SpeakMechanic.this, data);
            this.speech = SpeakMechanic.this.bubbleMessage.get(data);
            this.speech = Text.colorizeLegacy(this.speech);
            if (this.start()) {
                SpeakMechanic.this.sendChatSpeech(this.skillMetadata, SpeakMechanic.this.chatMessage.get(data));
            }
        }

        public SpeechTracker(AbstractEntity target, SkillMetadata data) {
            super((Aura)SpeakMechanic.this, data.getCaster(), target, data);
            this.speech = SpeakMechanic.this.bubbleMessage.get(data, target);
            if (this.start()) {
                SpeakMechanic.this.sendChatSpeech(this.skillMetadata, SpeakMechanic.this.chatMessage.get(data, target));
            }
        }

        @Override
        public void auraStart() {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Creating speech bubble...", new Object[0]);
            this.bubble = AbstractSkill.getPlugin().getHologramManager().createSpeechBubble(this.skillMetadata.getCaster());
            this.bubble.setYOffset(SpeakMechanic.this.offset);
            this.bubble.setLineLength(SpeakMechanic.this.maxLineLength);
            this.bubble.setLinePrefix(SpeakMechanic.this.linePrefix.get());
            this.bubble.setText(this.speech);
            this.executeAuraSkill(SpeakMechanic.this.onStartSkill, this.skillMetadata);
        }

        @Override
        public void auraTick() {
            this.executeAuraSkill(SpeakMechanic.this.onTickSkill, this.skillMetadata);
        }

        @Override
        public void auraStop() {
            this.bubble.terminate();
            if (SpeakMechanic.this.doEndSkillOnTerminate) {
                this.executeAuraSkill(SpeakMechanic.this.onEndSkill, this.skillMetadata);
            }
        }
    }
}

