/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import com.google.common.collect.Sets;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.SkillAdapter;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.compatibility.CompatibilityManager;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import io.lumine.xikage.mythicmobs.util.MythicUtil;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.Events;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.terminable.Terminable;
import io.lumine.xikage.mythicmobs.utils.terminable.TerminableRegistry;
import java.util.HashSet;
import java.util.Optional;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

@MythicMechanic(author="Ashijin", name="shootshulkerbullet", aliases={"shootshulker"}, description="Shoots a shulker bullet at the target entity")
public class ShootShulkerMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected int damage;
    protected float startYOffset;
    protected float startForwardOffset;
    protected float startSideOffset;
    protected Optional<Skill> onTickSkill = Optional.empty();
    protected Optional<Skill> onHitSkill = Optional.empty();
    protected Optional<Skill> onEndSkill = Optional.empty();
    protected int tickInterval;
    protected String onTickSkillName;
    protected String onHitSkillName;
    protected String onEndSkillName;
    protected String onStartSkillName;
    protected Boolean bounce;
    protected Boolean fromOrigin;
    protected Optional<String> disguise = Optional.empty();

    public ShootShulkerMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        String strProjectile = mlc.getString(new String[]{"type", "t"}, "arrow", new String[0]);
        this.damage = mlc.getInteger(new String[]{"damage", "d"}, 5);
        this.bounce = mlc.getBoolean(new String[]{"bounce"}, false);
        this.tickInterval = mlc.getInteger(new String[]{"interval", "int", "i"}, 4);
        this.startYOffset = mlc.getFloat(new String[]{"startyoffset", "syo"}, 0.0f);
        this.startForwardOffset = mlc.getFloat(new String[]{"forwardoffset", "startfoffset", "sfo"}, 0.0f);
        this.fromOrigin = mlc.getBoolean(new String[]{"fromorigin", "fo"}, false);
        this.disguise = Optional.ofNullable(mlc.getString(new String[]{"disguise", "d"}, null, new String[0]));
        this.onTickSkillName = mlc.getString(new String[]{"ontickskill", "ontick", "ot", "skill", "s", "meta", "m"});
        this.onHitSkillName = mlc.getString(new String[]{"onhitskill", "onhit", "oh"});
        this.onEndSkillName = mlc.getString(new String[]{"onendskill", "onend", "oe"});
        ShootShulkerMechanic.getPlugin().getSkillManager().queueSecondPass(() -> {
            if (this.onTickSkillName != null) {
                this.onTickSkill = ShootShulkerMechanic.getPlugin().getSkillManager().getSkill(this.onTickSkillName);
            }
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "ShootShulker Loaded onTick pointing at " + this.onTickSkillName, new Object[0]);
            if (this.onHitSkillName != null) {
                this.onHitSkill = ShootShulkerMechanic.getPlugin().getSkillManager().getSkill(this.onHitSkillName);
            }
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Loaded onHit pointing at " + this.onHitSkillName, new Object[0]);
            if (this.onEndSkillName != null) {
                this.onEndSkill = ShootShulkerMechanic.getPlugin().getSkillManager().getSkill(this.onEndSkillName);
            }
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Loaded onEnd pointing at " + this.onEndSkillName, new Object[0]);
        });
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        return this.shoot(data, target);
    }

    public boolean shoot(SkillMetadata data, AbstractEntity target) {
        SkillCaster caster = data.getCaster();
        AbstractLocation origin = data.getOrigin().clone();
        float power = data.getPower();
        if (!this.onTickSkill.isPresent() && this.onTickSkillName != null) {
            this.onTickSkill = ShootShulkerMechanic.getPlugin().getSkillManager().getSkill(this.onTickSkillName);
        }
        if (!this.onHitSkill.isPresent() && this.onHitSkillName != null) {
            this.onHitSkill = ShootShulkerMechanic.getPlugin().getSkillManager().getSkill(this.onHitSkillName);
        }
        if (!this.onEndSkill.isPresent() && this.onEndSkillName != null) {
            this.onEndSkill = ShootShulkerMechanic.getPlugin().getSkillManager().getSkill(this.onEndSkillName);
        }
        if (this.startYOffset > 0.0f) {
            origin = origin.add(0.0, this.startYOffset, 0.0);
        }
        if (this.startForwardOffset != 0.0f) {
            origin = MythicUtil.move(origin, this.startForwardOffset, 0.0, 0.0);
        }
        if (this.startSideOffset != 0.0f) {
            origin = MythicUtil.move(origin, 0.0, 0.0, this.startSideOffset);
        }
        AbstractEntity projectile = SkillAdapter.get().shootShulkerBullet(caster, target, origin, this);
        if (this.disguise.isPresent()) {
            ShootShulkerMechanic.getPlugin().getCompatibility();
            if (CompatibilityManager.LibsDisguises.enabled) {
                Entity entity = BukkitAdapter.adapt(projectile);
                ShootShulkerMechanic.getPlugin().getCompatibility();
                DisguiseAPI.disguiseEntity((Entity)entity, (Disguise)CompatibilityManager.LibsDisguises.getParsedDisguise(this.disguise.get()));
            }
        }
        new ProjectileTracker(data, projectile, power);
        return true;
    }

    public Boolean getBounce() {
        return this.bounce;
    }

    public Boolean getFromOrigin() {
        return this.fromOrigin;
    }

    protected class ProjectileTracker
    implements Runnable,
    Terminable {
        private final TerminableRegistry registry = TerminableRegistry.create();
        private SkillMetadata data;
        private SkillCaster caster;
        private AbstractEntity projectile;
        private boolean hasEnded = false;
        private float power;

        public ProjectileTracker(SkillMetadata caster, AbstractEntity projectile, float power) {
            this.caster = caster.getCaster();
            this.data = caster.deepClone();
            this.data.setIsAsync(true);
            this.projectile = projectile;
            this.power = power;
            this.registry.accept(Events.subscribe(EntityDamageByEntityEvent.class).filter(event -> event.getDamager() instanceof ShulkerBullet).filter(event -> event.getEntity() instanceof LivingEntity).filter(event -> event.getDamager().getUniqueId().equals(projectile.getUniqueId())).handler(this::doHitSkill));
            this.registry.accept(Schedulers.async().runRepeating(this, 0L, (long)ShootShulkerMechanic.this.tickInterval));
        }

        @Override
        public void run() {
            if (!this.projectile.isValid() || this.projectile.getBukkitEntity() instanceof Projectile && ((Projectile)this.projectile.getBukkitEntity()).isOnGround()) {
                this.doEndSkill();
                this.close();
            }
            if (ShootShulkerMechanic.this.onTickSkill.isPresent() && ShootShulkerMechanic.this.onTickSkill.get().isUsable(this.data)) {
                SkillMetadata sData = this.data.deepClone();
                HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
                targets.add(this.projectile.getLocation().clone());
                sData.setLocationTargets(targets);
                sData.setOrigin(this.projectile.getLocation().clone());
                sData.setPower(this.power);
                ShootShulkerMechanic.this.onTickSkill.get().execute(sData);
            }
        }

        public void doHitSkill(EntityDamageByEntityEvent event) {
            this.close();
            Projectile projectile = (Projectile)event.getDamager();
            AbstractEntity proj = BukkitAdapter.adapt((Entity)projectile);
            AbstractEntity target = BukkitAdapter.adapt(event.getEntity());
            HashSet<AbstractEntity> t = Sets.newHashSet();
            t.add(target);
            SkillMetadata meta = new SkillMetadata(SkillTrigger.ATTACK, this.caster, target, proj.getLocation(), t, null, this.power);
            if (ShootShulkerMechanic.this.damage == 0) {
                event.setCancelled(true);
            } else {
                event.setDamage((double)ShootShulkerMechanic.this.damage);
            }
            if (ShootShulkerMechanic.this.onHitSkill.isPresent() && ShootShulkerMechanic.this.onHitSkill.get().usable(meta, null)) {
                ShootShulkerMechanic.this.onHitSkill.get().execute(meta);
            }
        }

        private void doEndSkill() {
            if (!this.hasEnded && ShootShulkerMechanic.this.onEndSkill.isPresent()) {
                if (ShootShulkerMechanic.this.onEndSkill.get().isUsable(this.data)) {
                    SkillMetadata sData = this.data.deepClone();
                    HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
                    targets.add(this.projectile.getLocation().clone());
                    sData.setLocationTargets(targets);
                    sData.setOrigin(this.projectile.getLocation().clone());
                    sData.setPower(this.power);
                    ShootShulkerMechanic.this.onEndSkill.get().execute(sData);
                }
                this.hasEnded = true;
            }
        }

        @Override
        public void close() {
            this.registry.terminate();
        }
    }
}

