/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderDouble;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;

@MythicMechanic(author="jaylawl", name="setrotation", aliases={"setrot"}, description="Sets the target's yaw and/or pitch without teleporting it. Does not work on players!")
public class SetRotationMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    @MythicField(name="relative", aliases={"rel", "r"}, version="4.9", description="When set to true, adds to the target's yaw/pitch rather than setting it. Default=false")
    private boolean relative;
    @MythicField(name="yaw", aliases={"y"}, version="4.9", description="The yaw to be set/add - Either yaw or pitch is required")
    protected PlaceholderDouble yaw;
    @MythicField(name="pitch", aliases={"p"}, version="4.9", description="The pitch to be set/add - Either yaw or pitch is required")
    protected PlaceholderDouble pitch;

    public SetRotationMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.relative = mlc.getBoolean(new String[]{"relative", "rel", "r"}, false);
        this.yaw = mlc.getPlaceholderDouble(new String[]{"yaw", "y"}, -1337.69, new String[0]);
        this.pitch = mlc.getPlaceholderDouble(new String[]{"pitch", "p"}, -1337.69, new String[0]);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isPlayer()) {
            return false;
        }
        float yaw = (float)this.yaw.get(data, target);
        float pitch = (float)this.pitch.get(data, target);
        AbstractLocation loc = target.getLocation();
        if ((double)yaw == -1337.69) {
            yaw = loc.getYaw();
        } else if (this.relative) {
            yaw += loc.getYaw();
        }
        if ((double)pitch == -1337.69) {
            pitch = loc.getPitch();
        } else if (this.relative) {
            pitch += loc.getPitch();
        }
        SetRotationMechanic.getPlugin().getVolatileCodeHandler().getEntityHandler().setEntityRotation(target, pitch, yaw);
        return true;
    }
}

