/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.compatibility.CompatibilityManager;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.INoTargetSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="setname", description="Sets the casting mob's name")
public class SetNameMechanic
extends SkillMechanic
implements INoTargetSkill {
    private PlaceholderString name;

    public SetNameMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.name = mlc.getPlaceholderString(new String[]{"name", "n"}, null, new String[0]);
    }

    @Override
    public boolean cast(SkillMetadata data) {
        if (data.getCaster() instanceof ActiveMob) {
            String newName = this.name.get(data);
            ActiveMob caster = (ActiveMob)data.getCaster();
            caster.getEntity().getBukkitEntity().setCustomName(newName);
            if (CompatibilityManager.LibsDisguises != null && caster.getType() != null && caster.getType().getDisguise() != null) {
                CompatibilityManager.LibsDisguises.setDisguiseName(caster.getEntity(), newName);
            }
        }
        return true;
    }
}

