/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.items.LegacyItemConverter;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.utils.version.MinecraftVersions;
import io.lumine.xikage.mythicmobs.utils.version.ServerVersion;
import org.bukkit.Location;
import org.bukkit.Material;

public class SetBlockTypeMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    private Material material = Material.DIRT;
    private byte materialData = 0;

    public SetBlockTypeMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        String strMaterial = mlc.getString(new String[]{"material", "mat", "m"}, "DIRT", new String[0]).toUpperCase();
        this.materialData = (byte)mlc.getInteger(new String[]{"materialdata", "md", "data", "dv"}, 0);
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_15)) {
            try {
                this.material = this.materialData == 0 ? Material.valueOf((String)strMaterial) : LegacyItemConverter.getMaterial(strMaterial, this.materialData);
            }
            catch (Exception ex) {
                this.material = LegacyItemConverter.getMaterial(strMaterial, this.materialData);
            }
        } else {
            try {
                this.material = Material.valueOf((String)strMaterial);
            }
            catch (Exception ex) {
                MythicLogger.errorMechanicConfig(this, mlc, "'Material' must be a valid Material type.");
                this.material = Material.GRAVEL;
            }
        }
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.playEffect(target.getLocation());
        return true;
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playEffect(target);
        return true;
    }

    public void playEffect(AbstractLocation location) {
        Location l = BukkitAdapter.adapt(location);
        l.getBlock().setType(this.material);
    }
}

