/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;

public class SendResourcePackMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    private PlaceholderString url;
    private PlaceholderString hash;

    public SendResourcePackMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.target_creative = true;
        this.url = mlc.getPlaceholderString(new String[]{"url", "u", "link"}, null, new String[0]);
        this.hash = mlc.getPlaceholderString(new String[]{"hash", "h"}, "mythicmobs", new String[0]);
        if (this.url == null) {
            MythicLogger.errorMechanicConfig(this, mlc, "'URL' attribute must be set to a valid resource pack URL");
        }
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!target.isPlayer()) {
            return false;
        }
        MythicMobs.inst().getVolatileCodeHandler().sendResourcePack(target.asPlayer(), this.url.get(data, target), this.hash.get(data, target));
        return true;
    }
}

