/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractVector;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.IMetaSkill;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.numbers.Numbers;
import java.util.List;
import java.util.Optional;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.RayTraceResult;

@MythicMechanic(author="Ashijin", name="raytrace", premium=true, aliases={}, description="Executes a skill with the result of a raytrace")
public class RaytraceMechanic
extends SkillMechanic
implements IMetaSkill {
    protected String strEntitySkill;
    protected String strLocationSkill;
    protected Optional<Skill> entitySkill;
    protected Optional<Skill> locationSkill;
    protected String rtConditionString;
    protected double maxDistance;
    protected double rayWidth;
    protected boolean ignorePassableBlocks;
    protected FluidCollisionMode fluidCollisionMode;
    protected float projectileVelocityAccuracy;
    protected float projectileVelocityVertNoise;
    protected float projectileVelocityHorizNoise;
    protected float projectileVelocityVertNoiseBase;
    protected float projectileVelocityHorizNoiseBase;
    @MythicField(name="raytraceConditions", aliases={"rconditions", "rcond", "rc"}, defValue="NONE", version="4.10", description="Conditions applied to the bounce target")
    protected List<SkillCondition> raytraceConditions = null;

    public RaytraceMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.target_creative = true;
        if (!MythicMobs.isVolatile()) {
            MythicLogger.errorMechanicConfig(this, mlc, "RayTrace mechanic requires Mythic Premium");
            return;
        }
        this.strEntitySkill = mlc.getString(new String[]{"entityskill", "eskill", "es"}, null, new String[0]);
        this.strLocationSkill = mlc.getString(new String[]{"locationskill", "lskill", "ls"}, null, new String[0]);
        this.maxDistance = mlc.getDouble(new String[]{"maxdistance", "distance", "md", "d"}, 50.0);
        this.rayWidth = mlc.getDouble(new String[]{"raywidth", "rw", "w"}, 0.2);
        this.ignorePassableBlocks = mlc.getBoolean(new String[]{"ignorepassableblocks", "ignorepassable", "ip"}, true);
        try {
            String strFluidCollisionMode = mlc.getString(new String[]{"fluidcollisionmode", "fcm"}, "NEVER", new String[0]);
            this.fluidCollisionMode = FluidCollisionMode.valueOf((String)strFluidCollisionMode.toUpperCase());
        }
        catch (Error | Exception ex) {
            this.fluidCollisionMode = FluidCollisionMode.NEVER;
        }
        this.projectileVelocityAccuracy = mlc.getFloat(new String[]{"accuracy", "ac", "a"}, 1.0f);
        float defNoise = (1.0f - this.projectileVelocityAccuracy) * 45.0f;
        this.projectileVelocityVertNoise = mlc.getFloat(new String[]{"verticalnoise", "vn"}, defNoise) / 10.0f;
        this.projectileVelocityHorizNoise = mlc.getFloat(new String[]{"horizontalnoise", "hn"}, defNoise) * 5.0f;
        this.projectileVelocityVertNoiseBase = 0.0f - this.projectileVelocityVertNoise / 2.0f;
        this.projectileVelocityHorizNoiseBase = 0.0f - this.projectileVelocityHorizNoise / 2.0f;
        this.rtConditionString = mlc.getString(new String[]{"raytraceConditions", "rconditions", "rcond", "rc"}, null, new String[0]);
        RaytraceMechanic.getPlugin().getSkillManager().queueSecondPass(() -> {
            if (this.strEntitySkill != null) {
                this.entitySkill = RaytraceMechanic.getPlugin().getSkillManager().getSkill(this.strEntitySkill);
                if (!this.entitySkill.isPresent()) {
                    MythicLogger.errorMechanicConfig(this, mlc, "Could not find RayTrace Entity MetaSkill " + this.entitySkill);
                } else {
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ Loaded RayTraceMechanic EntitySkill successfully", new Object[0]);
                }
            }
            if (this.strLocationSkill != null) {
                this.locationSkill = RaytraceMechanic.getPlugin().getSkillManager().getSkill(this.strLocationSkill);
                if (!this.locationSkill.isPresent()) {
                    MythicLogger.errorMechanicConfig(this, mlc, "Could not find RayTrace Location MetaSkill " + this.entitySkill);
                } else {
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ Loaded RayTraceMechanic LocationSkill successfully", new Object[0]);
                }
            }
            if (this.rtConditionString != null) {
                this.raytraceConditions = RaytraceMechanic.getPlugin().getSkillManager().getConditions(this.rtConditionString);
            }
        });
    }

    @Override
    public boolean cast(SkillMetadata data) {
        RayTraceResult result;
        float noise;
        if (!MythicMobs.isVolatile()) {
            MythicLogger.errorMechanicConfig(this, this.config, "RayTrace mechanic requires Mythic Premium");
            return false;
        }
        LivingEntity caster = (LivingEntity)data.getCaster().getEntity().getBukkitEntity();
        AbstractLocation aSLocation = data.getCaster().getEntity().getEyeLocation();
        Location location = BukkitAdapter.adapt(aSLocation);
        AbstractVector aDirection = aSLocation.getDirection();
        if (this.projectileVelocityHorizNoise > 0.0f) {
            noise = (float)((double)this.projectileVelocityHorizNoiseBase + Numbers.randomDouble() * (double)this.projectileVelocityHorizNoise);
            aDirection.rotate(noise);
        }
        if (this.projectileVelocityVertNoise > 0.0f) {
            noise = (float)((double)this.projectileVelocityVertNoiseBase + Numbers.randomDouble() * (double)this.projectileVelocityVertNoise);
            aDirection.add(new AbstractVector(0.0f, noise, 0.0f)).normalize();
        }
        if ((result = RaytraceMechanic.getPlugin().getVolatileCodeHandler().getWorldHandler().rayTrace(location, BukkitAdapter.adapt(aDirection), this.maxDistance, this.rayWidth, entity -> {
            if (entity.getUniqueId().equals(caster.getUniqueId())) {
                return false;
            }
            if (this.raytraceConditions != null) {
                for (SkillCondition condition : this.raytraceConditions) {
                    if (condition.evaluateEntity(BukkitAdapter.adapt(entity))) continue;
                    return false;
                }
            }
            return true;
        }, material -> material == Material.BARRIER)) != null) {
            if (this.entitySkill != null && this.entitySkill.isPresent() && result.getHitEntity() != null) {
                AbstractEntity aEntity = BukkitAdapter.adapt(result.getHitEntity());
                if (result.getHitPosition().getY() - aEntity.getLocation().getY() >= result.getHitEntity().getBoundingBox().getHeight() - 0.4) {
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Mechanic was a headshot", new Object[0]);
                    data.setPower(data.getPower() * 2.0f);
                }
                SkillMetadata entityData = data.deepClone().setEntityTarget(aEntity);
                Skill skill = this.entitySkill.get();
                if (skill.isUsable(entityData)) {
                    skill.execute(entityData);
                }
            }
            if (this.locationSkill.isPresent()) {
                Location loc = result.getHitPosition().toLocation(caster.getWorld());
                AbstractLocation aLocation = BukkitAdapter.adapt(loc);
                SkillMetadata locationData = data.deepClone().setLocationTarget(aLocation);
                if (result.getHitBlock() != null) {
                    locationData.getVariables().putString("hit-block-type", result.getHitBlock().getType().toString());
                } else {
                    locationData.getVariables().putString("hit-block-type", "AIR");
                }
                Skill skill = this.locationSkill.get();
                if (skill.isUsable(locationData)) {
                    skill.execute(locationData);
                }
            }
        } else if (this.locationSkill.isPresent()) {
            AbstractLocation aLocation = BukkitAdapter.adapt(((Player)BukkitAdapter.adapt(data.getCaster().getEntity())).getTargetBlock(RaytraceMechanic.getPlugin().getConfiguration().getTransparentBlocks(), (int)this.maxDistance).getLocation());
            SkillMetadata locationData = data.deepClone().setLocationTarget(aLocation);
            Skill skill = this.locationSkill.get();
            if (skill.isUsable(locationData)) {
                skill.execute(locationData);
            }
        }
        return true;
    }
}

