/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import com.google.common.collect.Lists;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.IMetaSkill;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.numbers.Numbers;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@MythicMechanic(author="Ashijin", name="randomskill", aliases={"randommeta"}, description="Executes a random metaskill")
public class RandomSkillMechanic
extends SkillMechanic
implements IMetaSkill {
    protected List<Skill> skills = Lists.newArrayList();

    public RandomSkillMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.target_creative = true;
        String s2 = mlc.getString(new String[]{"skills", "s", "metas", "meta", "m"});
        String[] ss = s2.split(",");
        RandomSkillMechanic.getPlugin().getSkillManager().queueSecondPass(() -> {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Loading RandomSkillMechanic mechanics -> {0}", s2);
            for (String sx : ss) {
                if (sx == null) continue;
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Loading RandomSkill skill {0}", sx);
                Optional<Skill> metaskill = RandomSkillMechanic.getPlugin().getSkillManager().getSkill(sx);
                if (!metaskill.isPresent()) {
                    MythicLogger.errorMechanicConfig(this, mlc, "Could not find MetaSkill " + sx);
                    continue;
                }
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ Loaded MetaSkillMechanic successfully", new Object[0]);
                this.skills.add(metaskill.get());
            }
        });
    }

    @Override
    public boolean cast(SkillMetadata data) {
        ArrayList<Skill> skills = Lists.newArrayList(this.skills);
        while (!skills.isEmpty()) {
            Skill ms = skills.size() > 1 ? (Skill)skills.get(Numbers.randomInt(skills.size())) : (Skill)skills.get(0);
            if (ms.usable(data, null)) {
                ms.execute(data);
                return true;
            }
            skills.remove(ms);
        }
        return false;
    }
}

