/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.numbers.Numbers;
import java.util.ArrayList;
import java.util.List;

@MythicMechanic(author="Ashijin", name="randommessage", aliases={"randommsg", "rmsg", "rm"}, description="Sends a random message to the target player")
public class RandomMessageMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected static boolean noloop = false;
    protected List<PlaceholderString> messages = new ArrayList<PlaceholderString>();

    public RandomMessageMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.target_creative = true;
        try {
            String m3 = mlc.getString(new String[]{"messages", "message", "msg", "msgs", "m"});
            for (String s2 : m3.split(",")) {
                s2 = s2.trim();
                this.messages.add(new PlaceholderString(s2));
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Loaded RandomMessage " + s2.substring(1, s2.length() - 1), new Object[0]);
            }
        }
        catch (Exception ex) {
            MythicLogger.errorMechanicConfig(this, mlc, "The 'messages' attribute is required.");
            this.messages.add(new PlaceholderString("INCORRECTLY CONFIGURED. SEE CONSOLE ON RELOAD."));
        }
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        PlaceholderString message = this.messages.get(Numbers.randomInt(this.messages.size()));
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Executing RandomMessage skill with message: " + message, new Object[0]);
        if (target.isPlayer()) {
            target.asPlayer().sendMessage(message.get(data, target));
            return true;
        }
        return false;
    }
}

