/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.tasks.Scheduler;
import java.util.HashSet;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

@MythicMechanic(author="Ashijin", name="rally", aliases={"callforhelp"}, description="Calls for nearby entities to attack the target")
public class RallyMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected double hRadius;
    protected double vRadius;
    protected boolean overwriteTarget;
    HashSet<MythicMob> mmTypes = new HashSet();
    HashSet<BukkitEntityType> meTypes = new HashSet();

    public RallyMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.hRadius = mlc.getDouble("radius", 10.0);
        this.vRadius = mlc.getDouble("radius", 10.0);
        this.hRadius = mlc.getDouble("r", this.hRadius);
        this.vRadius = mlc.getDouble("r", this.vRadius);
        this.hRadius = mlc.getDouble("hradius", this.hRadius);
        this.vRadius = mlc.getDouble("vradius", this.vRadius);
        this.overwriteTarget = mlc.getBoolean(new String[]{"overwritetarget, ot"}, true);
        String typeString = mlc.getString(new String[]{"types", "type", "t"}, "", new String[0]);
        String[] types = typeString.split(",");
        RallyMechanic THIS = this;
        Scheduler.runLaterSync(() -> {
            for (String s2 : types) {
                MythicMob mm3 = MythicMobs.inst().getMobManager().getMythicMob(s2);
                if (mm3 != null) {
                    THIS.mmTypes.add(mm3);
                    continue;
                }
                BukkitEntityType me = BukkitEntityType.getMythicEntity(s2);
                if (me != null) {
                    THIS.meTypes.add(me);
                    continue;
                }
                MythicLogger.errorMechanicConfig(this, mlc, "The 'type' attribute must be a valid MythicMob or MythicEntity type.");
            }
        }, 5L);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        List moblist = data.getCaster().getEntity().getBukkitEntity().getNearbyEntities(this.hRadius, this.vRadius, this.hRadius);
        block0: for (Entity e : moblist) {
            if (!(e instanceof LivingEntity)) continue;
            ActiveMob amx = MythicMobs.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt(e));
            if (amx != null && this.mmTypes.contains(amx.getType())) {
                if (!this.overwriteTarget && amx.hasTarget()) continue;
                amx.setTarget(target);
                continue;
            }
            for (BukkitEntityType me : this.meTypes) {
                if (!me.compare(e)) continue;
                MythicMobs.inst().getVolatileCodeHandler().getAIHandler().setTarget((LivingEntity)e, (LivingEntity)BukkitAdapter.adapt(target));
                continue block0;
            }
        }
        return true;
    }
}

