/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractVector;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.projectiles.Projectile;
import io.lumine.xikage.mythicmobs.util.BlockUtil;
import io.lumine.xikage.mythicmobs.util.MythicUtil;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.numbers.Numbers;
import java.util.HashSet;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

@MythicMechanic(author="Ashijin", name="projectile", aliases={"p"}, description="Launches a custom projectile at the target")
public class ProjectileMechanic
extends Projectile
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected ProjectileType type;
    protected float projectileGravity;
    protected boolean hugSurface;
    protected float heightFromSurface;

    public ProjectileMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        String type = mlc.getString("type", "NORMAL");
        this.type = ProjectileType.valueOf(type.toUpperCase());
        this.projectileGravity = mlc.getFloat(new String[]{"gravity", "g"}, 0.0f);
        this.hugSurface = mlc.getBoolean(new String[]{"hugsurface", "hs"}, false);
        this.heightFromSurface = mlc.getFloat(new String[]{"heightfromsurface", "hfs"}, 0.5f);
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        try {
            new ProjectileMechanicTracker(data, target.clone().add(0.0, this.targetYOffset, 0.0));
            return true;
        }
        catch (Exception ex) {
            MythicLogger.error("An error occurred executing a Projectile Mechanic", ex);
            return false;
        }
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        return this.castAtLocation(data, target.getLocation().add(0.0, target.getEyeHeight() / 2.0, 0.0));
    }

    protected static enum ProjectileType {
        NORMAL,
        METEOR;

    }

    public class ProjectileMechanicTracker
    extends Projectile.ProjectileTracker {
        private float gravity;
        private AbstractLocation target;
        private int currentX;
        private int currentZ;

        public ProjectileMechanicTracker(SkillMetadata data, AbstractLocation target) {
            super(ProjectileMechanic.this, data, target);
            this.gravity = 0.0f;
            this.target = target;
            this.start();
        }

        @Override
        public void projectileStart() {
            float noise;
            float velocity;
            if (ProjectileMechanic.this.type == ProjectileType.METEOR) {
                this.startLocation = this.target.clone();
                this.startLocation.add(0.0, ProjectileMechanic.this.heightFromSurface, 0.0);
                if (ProjectileMechanic.this.projectileGravity <= 0.0f) {
                    this.gravity = ProjectileMechanic.this.projectileVelocity;
                    this.gravity = this.gravity > 0.0f ? this.gravity / ProjectileMechanic.this.ticksPerSecond : 0.0f;
                } else {
                    this.gravity = ProjectileMechanic.this.projectileGravity > 0.0f ? ProjectileMechanic.this.projectileGravity / ProjectileMechanic.this.ticksPerSecond : 0.0f;
                }
                velocity = 0.0f;
            } else {
                this.startLocation = ProjectileMechanic.this.sourceIsOrigin ? this.data.getOrigin().clone() : this.data.getCaster().getEntity().getLocation().clone();
                velocity = ProjectileMechanic.this.projectileVelocity / ProjectileMechanic.this.ticksPerSecond;
                float f = this.gravity = ProjectileMechanic.this.projectileGravity > 0.0f ? ProjectileMechanic.this.projectileGravity / ProjectileMechanic.this.ticksPerSecond : 0.0f;
                if (ProjectileMechanic.this.startYOffset != 0.0f) {
                    this.startLocation.setY(this.startLocation.getY() + (double)ProjectileMechanic.this.startYOffset);
                }
                if (ProjectileMechanic.this.startForwardOffset != 0.0f) {
                    this.startLocation = MythicUtil.move(this.startLocation, ProjectileMechanic.this.startForwardOffset, 0.0, 0.0);
                }
                if (ProjectileMechanic.this.startSideOffset != 0.0f) {
                    this.startLocation = MythicUtil.move(this.startLocation, 0.0, 0.0, ProjectileMechanic.this.startSideOffset);
                }
            }
            this.previousLocation = this.startLocation.clone();
            this.currentLocation = this.startLocation.clone();
            if (this.currentLocation == null) {
                return;
            }
            this.currentVelocity = this.target.toVector().subtract(this.currentLocation.toVector()).normalize();
            if (ProjectileMechanic.this.projectileVelocityHorizOffset != 0.0f || ProjectileMechanic.this.projectileVelocityHorizNoise > 0.0f) {
                noise = 0.0f;
                if (ProjectileMechanic.this.projectileVelocityHorizNoise > 0.0f) {
                    noise = (float)((double)ProjectileMechanic.this.projectileVelocityHorizNoiseBase + Numbers.randomDouble() * (double)ProjectileMechanic.this.projectileVelocityHorizNoise);
                }
                this.currentVelocity.rotate(ProjectileMechanic.this.projectileVelocityHorizOffset + noise);
            }
            if (ProjectileMechanic.this.projectileVelocityVertOffset != 0.0f || ProjectileMechanic.this.projectileVelocityVertNoise > 0.0f) {
                noise = 0.0f;
                if (ProjectileMechanic.this.projectileVelocityVertNoise > 0.0f) {
                    noise = (float)((double)ProjectileMechanic.this.projectileVelocityVertNoiseBase + Numbers.randomDouble() * (double)ProjectileMechanic.this.projectileVelocityVertNoise);
                }
                this.currentVelocity.add(new AbstractVector(0.0f, ProjectileMechanic.this.projectileVelocityVertOffset + noise, 0.0f)).normalize();
            }
            if (ProjectileMechanic.this.hugSurface) {
                this.currentLocation.setY((float)((int)this.currentLocation.getY()) + ProjectileMechanic.this.heightFromSurface);
                this.currentVelocity.setY(0).normalize();
            }
            if (ProjectileMechanic.this.powerAffectsVelocity) {
                this.currentVelocity.multiply(this.power);
            }
            this.currentVelocity.multiply(velocity);
            if (ProjectileMechanic.this.projectileGravity > 0.0f) {
                this.currentVelocity.setY(this.currentVelocity.getY() - (double)this.gravity);
            }
        }

        public void setVelocity(double value) {
            this.currentVelocity = this.currentVelocity.normalize().multiply(value);
        }

        public void modifyVelocity(double v) {
            this.currentVelocity = this.currentVelocity.multiply(v);
        }

        public void setGravity(float p) {
            this.gravity = p;
        }

        public void modifyGravity(float p) {
            this.gravity *= p;
        }

        @Override
        public void projectileTick() {
            this.previousLocation = this.currentLocation.clone();
            this.currentLocation.add(this.currentVelocity);
            if (ProjectileMechanic.this.hugSurface) {
                if (this.currentLocation.getBlockX() != this.currentX || this.currentLocation.getBlockZ() != this.currentZ) {
                    boolean ok;
                    int attempts;
                    Object b = BukkitAdapter.adapt(this.currentLocation.subtract(0.0, ProjectileMechanic.this.heightFromSurface, 0.0)).getBlock();
                    if (BlockUtil.isPathable((Block)b, this)) {
                        attempts = 0;
                        ok = false;
                        while (attempts++ < 10) {
                            if (BlockUtil.isPathable((Block)(b = b.getRelative(BlockFace.DOWN)), this)) {
                                this.currentLocation.add(0.0, -1.0, 0.0);
                                continue;
                            }
                            ok = true;
                            break;
                        }
                        if (!ok) {
                            this.terminate();
                            return;
                        }
                    } else {
                        attempts = 0;
                        ok = false;
                        while (attempts++ < 10) {
                            b = b.getRelative(BlockFace.UP);
                            this.currentLocation.add(0.0, 1.0, 0.0);
                            if (!BlockUtil.isPathable((Block)b)) continue;
                            ok = true;
                            break;
                        }
                        if (!ok) {
                            this.terminate();
                            return;
                        }
                    }
                    this.currentLocation.setY((float)((int)this.currentLocation.getY()) + ProjectileMechanic.this.heightFromSurface);
                    this.currentX = this.currentLocation.getBlockX();
                    this.currentZ = this.currentLocation.getBlockZ();
                }
            } else if (ProjectileMechanic.this.projectileGravity != 0.0f) {
                this.currentVelocity.setY(this.currentVelocity.getY() - (double)(ProjectileMechanic.this.projectileGravity / ProjectileMechanic.this.ticksPerSecond));
            }
            if (ProjectileMechanic.this.stopOnHitGround && !BlockUtil.isPathable(BukkitAdapter.adapt(this.currentLocation).getBlock(), this)) {
                this.currentLocation = this.previousLocation;
                this.terminate();
                return;
            }
            if (this.bullet != null) {
                this.applyBulletVelocity();
            }
            if (this.inRange != null && this.inRange.size() > 0) {
                this.immune.entrySet().removeIf(entry -> (Long)entry.getValue() < System.currentTimeMillis() - 2000L);
                for (AbstractEntity e : this.inRange) {
                    if (e.isDead() || !this.getBoundingBox().overlaps(e.getBukkitEntity().getBoundingBox()) || this.immune.containsKey(e)) continue;
                    this.targets.add(e);
                    this.immune.put(e, System.currentTimeMillis());
                    break;
                }
            }
            if (ProjectileMechanic.this.onTickSkill.isPresent() && ((Skill)ProjectileMechanic.this.onTickSkill.get()).isUsable(this.data)) {
                SkillMetadata sData = this.data.deepClone();
                AbstractLocation location = ProjectileMechanic.this.bulletType == Projectile.BulletType.ARROW ? this.previousLocation.clone() : this.currentLocation.clone();
                HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
                targets.add(location);
                sData.setLocationTargets(targets);
                sData.setOrigin(location);
                ((Skill)ProjectileMechanic.this.onTickSkill.get()).execute(sData);
            }
            if (this.targets.size() > 0) {
                this.doHit((HashSet)this.targets.clone());
                if (ProjectileMechanic.this.stopOnHitEntity) {
                    this.terminate();
                }
            }
            this.targets.clear();
        }

        @Override
        public void applyBulletVelocity() {
            if (ProjectileMechanic.this.bulletType == Projectile.BulletType.ITEM) {
                AbstractLocation ol = this.previousLocation.clone().subtract(0.0, 0.35, 0.0);
                AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().setItemPosition(this.bullet, ol);
                this.bullet.setVelocity(this.currentLocation.toVector().subtract(this.previousLocation.toVector()));
            } else if (ProjectileMechanic.this.bulletType == Projectile.BulletType.ARROW) {
                this.bullet.setVelocity(this.currentLocation.toVector().subtract(this.bullet.getLocation().clone().toVector()).multiply(0.25));
            } else if (ProjectileMechanic.this.bulletType == Projectile.BulletType.MOB) {
                AbstractLocation ol = this.currentLocation.clone().add(this.currentVelocity).subtract(0.0, 1.35, 0.0);
                if (ProjectileMechanic.this.bulletSpin != 0.0f) {
                    float newSpin = this.bullet.getLocation().getYaw() + ProjectileMechanic.this.bulletSpin;
                    ol.setYaw(newSpin);
                } else if (ProjectileMechanic.this.bulletMatchDirection) {
                    ol.setDirection(this.currentVelocity);
                }
                this.bullet.teleport(ol);
            } else {
                this.bullet.setVelocity(this.currentLocation.toVector().subtract(this.bullet.getLocation().clone().toVector()).multiply(1));
                if (ProjectileMechanic.this.bulletSpin > 0.0f) {
                    float newSpin = this.bullet.getLocation().getYaw() + ProjectileMechanic.this.bulletSpin;
                    AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().setEntityRotation(this.bullet, newSpin, newSpin);
                }
            }
        }

        private void doHit(HashSet<AbstractEntity> targets) {
            if (ProjectileMechanic.this.onHitSkill.isPresent()) {
                SkillMetadata sData = this.data.deepClone();
                sData.setEntityTargets(targets);
                sData.setOrigin(this.currentLocation.clone());
                if (((Skill)ProjectileMechanic.this.onHitSkill.get()).isUsable(sData)) {
                    ((Skill)ProjectileMechanic.this.onHitSkill.get()).execute(sData);
                }
            }
        }

        @Override
        public void setCancelled() {
            this.terminate();
        }

        @Override
        public boolean getCancelled() {
            return this.components.hasTerminated();
        }
    }
}

