/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffect;

@MythicMechanic(author="Ashijin", name="potionclear", aliases={"clearpotions", "clearpotion"}, description="Clears all potion effects on the target entity")
public class PotionClearMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    public PotionClearMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        LivingEntity l = (LivingEntity)target.getBukkitEntity();
        for (PotionEffect pe : l.getActivePotionEffects()) {
            l.removePotionEffect(pe.getType());
        }
        return true;
    }
}

