/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.version.ServerVersion;
import org.bukkit.Location;
import org.bukkit.Sound;

@MythicMechanic(author="Ashijin", name="playBlockStepSound", aliases={"blockStepSound"}, description="Plays the target block's stepping sound. Requires Paper.")
public class PlayBlockStepSoundMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    private float volume;
    private float pitch;

    public PlayBlockStepSoundMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.pitch = mlc.getFloat(new String[]{"pitch", "p"}, 1.0f);
        this.volume = mlc.getFloat(new String[]{"volume", "v"}, 1.0f);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.playEffect(target.getLocation());
        return true;
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playEffect(target);
        return true;
    }

    public void playEffect(AbstractLocation location) {
        if (!ServerVersion.isPaper()) {
            MythicLogger.errorMechanicConfig(this, this.config, "Mechanic requires PaperSpigot");
            return;
        }
        Location l = BukkitAdapter.adapt(location);
        Sound sound = l.getBlock().getSoundGroup().getStepSound();
        l.getWorld().playSound(l, sound, this.volume, this.pitch);
    }
}

