/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractVector;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.ParticleMaker;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.mechanics.ParticleEffect;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderInt;
import io.lumine.xikage.mythicmobs.util.RandomUtil;
import io.lumine.xikage.mythicmobs.utils.numbers.Numbers;
import io.lumine.xikage.mythicmobs.utils.version.MinecraftVersions;
import io.lumine.xikage.mythicmobs.utils.version.ServerVersion;
import java.util.Collection;

public class ParticleSphereEffect
extends ParticleEffect
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    private PlaceholderInt points;
    private float radius;

    public ParticleSphereEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.ASYNC_ONLY;
        this.points = this.amount;
        this.amount = PlaceholderInt.of("1");
        this.radius = mlc.getFloat("radius", 0.0f);
        this.radius = mlc.getFloat("r", this.radius);
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        Collection<AbstractEntity> audience = this.audience.get(data, null);
        this.playParticleSphereEffect(data, target, audience);
        return true;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        Collection<AbstractEntity> audience = this.audience.get(data, target);
        this.playParticleSphereEffect(data, target.getLocation(), audience);
        return true;
    }

    protected void playParticleSphereEffect(SkillMetadata data, AbstractLocation t, Collection<AbstractEntity> audience) {
        AbstractLocation target = t;
        AbstractLocation location = target.clone();
        if (this.setYaw) {
            location.setYaw(this.yaw);
        }
        if (this.setPitch) {
            location.setPitch(this.pitch);
        }
        location.add(0.0, this.yOffset, 0.0);
        int points = this.points.get(data);
        for (int i = 0; i < points; ++i) {
            AbstractVector vector = RandomUtil.getRandomVector().multiply(this.radius);
            location.add(vector);
            if (this.directional) {
                this.playDirectionalParticleEffect(data, target, target, location, audience);
            } else {
                this.playParticleEffect(data, location, audience);
            }
            location.subtract(vector);
        }
    }

    protected void playDirectionalParticleEffect(SkillMetadata data, AbstractLocation origin, AbstractLocation target, AbstractLocation spawn, Collection<AbstractEntity> audience) {
        AbstractVector direction = this.directionReversed ? origin.toVector().subtract(target.clone().toVector()).normalize() : target.toVector().subtract(origin.clone().toVector()).normalize();
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_15)) {
            if (this.particleData == null) {
                this.particle.sendDirectional(audience, origin, this.pSpeed, 1, this.xSpread, this.vSpread, this.zSpread, direction);
            }
        } else {
            AbstractLocation ln = spawn.clone().add((double)(0.0f - this.xSpread) + Numbers.randomDouble() * (double)this.xSpread * 2.0, (double)this.vSpread + Numbers.randomDouble() * (double)this.vSpread * 2.0, (double)(0.0f - this.zSpread) + Numbers.randomDouble() * (double)this.zSpread * 2.0);
            new ParticleMaker.ParticlePacket(this.strParticle, direction, this.pSpeed, 1, true).send(ln, this.viewDistance);
        }
    }
}

