/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractVector;
import io.lumine.xikage.mythicmobs.adapters.AbstractWorld;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.ParticleMaker;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.mechanics.ParticleEffect;
import io.lumine.xikage.mythicmobs.utils.numbers.Numbers;
import io.lumine.xikage.mythicmobs.utils.version.MinecraftVersions;
import io.lumine.xikage.mythicmobs.utils.version.ServerVersion;
import java.util.Collection;

public class ParticleRingEffect
extends ParticleEffect
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    private float radius;
    private int points;
    private float inc;

    public ParticleRingEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.ASYNC_ONLY;
        this.points = mlc.getInteger(new String[]{"points", "pts"}, 8);
        this.radius = mlc.getFloat(new String[]{"radius", "r"}, 10.0f);
        if (this.points <= 0) {
            this.points = 1;
        }
        this.inc = 360.0f / (float)this.points;
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        Collection<AbstractEntity> audience = this.audience.get(data, null);
        if (this.fromOrigin) {
            this.playParticleRingEffect(data, data.getOrigin(), audience);
        } else {
            this.playParticleRingEffect(data, target, audience);
        }
        return false;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        Collection<AbstractEntity> audience = this.audience.get(data, target);
        this.playParticleRingEffect(data, target.getLocation(), audience);
        return false;
    }

    protected void playParticleRingEffect(SkillMetadata data, AbstractLocation t, Collection<AbstractEntity> audience) {
        AbstractLocation target = t;
        if (target == null) {
            return;
        }
        double bx = target.getX();
        double y = target.getY() + (double)this.yOffset;
        double bz = target.getZ();
        AbstractWorld w = target.getWorld();
        for (double i = 0.0; i < 360.0; i += (double)this.inc) {
            double angle = i * Math.PI / 180.0;
            double x = bx + (double)this.radius * Math.cos(angle);
            double z = bz + (double)this.radius * Math.sin(angle);
            AbstractLocation l = new AbstractLocation(w, x, y, z);
            if (this.directional) {
                this.playDirectionalParticleEffect(data, l, target, l, audience);
                continue;
            }
            this.playParticleEffect(data, l, audience);
        }
    }

    protected void playDirectionalParticleEffect(SkillMetadata data, AbstractLocation origin, AbstractLocation target, AbstractLocation spawn, Collection<AbstractEntity> audience) {
        AbstractVector direction = this.directionReversed ? origin.toVector().subtract(target.clone().toVector()).normalize() : target.toVector().subtract(origin.clone().toVector()).normalize();
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_15)) {
            if (this.particleData == null) {
                this.particle.sendDirectional(audience, origin, this.pSpeed, this.amount.get(data), this.xSpread, this.vSpread, this.zSpread, direction);
            }
        } else {
            int amount = this.amount.get(data) / this.points;
            for (int i = 0; i < amount; ++i) {
                AbstractLocation ln = spawn.clone().add((double)(0.0f - this.xSpread) + Numbers.randomDouble() * (double)this.xSpread * 2.0, (double)this.vSpread + Numbers.randomDouble() * (double)this.vSpread * 2.0, (double)(0.0f - this.zSpread) + Numbers.randomDouble() * (double)this.zSpread * 2.0);
                new ParticleMaker.ParticlePacket(this.strParticle, direction, this.pSpeed, 1, true).send(ln, this.viewDistance);
            }
        }
    }
}

