/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractVector;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.mechanics.ParticleEffect;
import io.lumine.xikage.mythicmobs.util.VectorUtils;
import io.lumine.xikage.mythicmobs.utils.tasks.Scheduler;
import java.util.Collection;
import java.util.Optional;

public class ParticleOrbitalEffect
extends ParticleEffect
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected float radius;
    protected int points;
    protected int interval;
    protected int iterations;
    protected double velocity = 1.0;
    protected boolean rotate = false;
    protected boolean reversed = false;
    protected double xRotation = 0.0;
    protected double yRotation = 0.0;
    protected double zRotation = 0.0;
    protected double angularVelocityX = 0.015707963267948967;
    protected double angularVelocityY = 0.018479956785822312;
    protected double angularVelocityZ = 0.02026833970057931;
    protected double xOffset = 0.0;
    protected double yOffset = 0.0;
    protected double zOffset = 0.0;

    public ParticleOrbitalEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.ASYNC_ONLY;
        this.radius = mlc.getFloat(new String[]{"radius", "r"}, 4.0f);
        this.points = mlc.getInteger(new String[]{"points", "p"}, 20);
        this.iterations = mlc.getInteger(new String[]{"ticks", "t"}, 100);
        this.interval = mlc.getInteger(new String[]{"interval", "in", "i"}, 10);
        this.xRotation = mlc.getDouble(new String[]{"rotationx", "rotx", "rx"}, 0.0);
        this.yRotation = mlc.getDouble(new String[]{"rotationy", "roty", "ry"}, 0.0);
        this.zRotation = mlc.getDouble(new String[]{"rotationz", "rotz", "rz"}, 0.0);
        this.xOffset = mlc.getDouble(new String[]{"offsetx", "offx", "ox"}, 0.0);
        this.yOffset = mlc.getDouble(new String[]{"offsety", "offy", "oy"}, 0.0);
        this.zOffset = mlc.getDouble(new String[]{"offsetz", "offz", "oz"}, 0.0);
        this.angularVelocityX = mlc.getDouble(new String[]{"angularvelocityx", "avx", "vx"}, 0.0);
        this.angularVelocityY = mlc.getDouble(new String[]{"angularvelocityy", "avy", "vy"}, 0.0);
        this.angularVelocityZ = mlc.getDouble(new String[]{"angularvelocityz", "avz", "vz"}, 0.0);
        this.angularVelocityX = this.angularVelocityX == 0.0 ? 0.0 : Math.PI / this.angularVelocityX;
        this.angularVelocityY = this.angularVelocityY == 0.0 ? 0.0 : Math.PI / this.angularVelocityY;
        this.angularVelocityZ = this.angularVelocityZ == 0.0 ? 0.0 : Math.PI / this.angularVelocityZ;
        this.rotate = mlc.getBoolean(new String[]{"rotate"}, this.angularVelocityX > 0.0 || this.angularVelocityY > 0.0 || this.angularVelocityZ > 0.0);
        this.reversed = mlc.getBoolean(new String[]{"reversed", "reverse"}, false);
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        new Animator(data, target);
        return true;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        new Animator(data, target);
        return true;
    }

    private class Animator
    implements Runnable {
        private SkillMetadata data;
        private Optional<AbstractEntity> entity = Optional.empty();
        private Optional<AbstractLocation> location = Optional.empty();
        private int iteration = 0;
        private int step = 0;
        private Scheduler.Task task;

        public Animator(SkillMetadata data, AbstractEntity entity) {
            this.data = data;
            this.entity = Optional.of(entity);
            this.task = Scheduler.runTaskRepeatingAsync(this, 0L, (long)ParticleOrbitalEffect.this.interval);
        }

        public Animator(SkillMetadata data, AbstractLocation location) {
            this.data = data;
            this.location = Optional.of(location);
            this.task = Scheduler.runTaskRepeatingAsync(this, 0L, (long)ParticleOrbitalEffect.this.interval);
        }

        public AbstractLocation getLocation() {
            if (this.entity.isPresent()) {
                return this.entity.get().getLocation().add(ParticleOrbitalEffect.this.xOffset, ParticleOrbitalEffect.this.yOffset, ParticleOrbitalEffect.this.zOffset);
            }
            return this.location.get().clone().add(ParticleOrbitalEffect.this.xOffset, ParticleOrbitalEffect.this.yOffset, ParticleOrbitalEffect.this.zOffset);
        }

        @Override
        public void run() {
            AbstractLocation location = this.getLocation();
            double inc = Math.PI * 2 / (double)ParticleOrbitalEffect.this.points;
            double angle = (double)this.step * inc;
            AbstractVector v = new AbstractVector();
            v.setX(Math.cos(angle) * (double)ParticleOrbitalEffect.this.radius);
            v.setZ(Math.sin(angle) * (double)ParticleOrbitalEffect.this.radius);
            VectorUtils.rotateVector(v, ParticleOrbitalEffect.this.xRotation, ParticleOrbitalEffect.this.yRotation, ParticleOrbitalEffect.this.zRotation);
            if (ParticleOrbitalEffect.this.rotate) {
                VectorUtils.rotateVector(v, ParticleOrbitalEffect.this.angularVelocityX * (double)this.step, ParticleOrbitalEffect.this.angularVelocityY * (double)this.step, ParticleOrbitalEffect.this.angularVelocityZ * (double)this.step);
            }
            AbstractLocation loc = ParticleOrbitalEffect.this.reversed ? location.subtract(v) : location.add(v);
            Collection<AbstractEntity> audience = ParticleOrbitalEffect.this.audience.get(this.data, this.data.getCaster().getEntity());
            ParticleOrbitalEffect.this.playParticleEffect(this.data, loc, audience);
            ++this.step;
            if (++this.iteration * ParticleOrbitalEffect.this.interval >= ParticleOrbitalEffect.this.iterations) {
                this.task.terminate();
            }
        }
    }
}

