/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractVector;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitParticle;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.ParticleMaker;
import io.lumine.xikage.mythicmobs.skills.SkillAudience;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderInt;
import io.lumine.xikage.mythicmobs.util.MythicUtil;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.numbers.Numbers;
import io.lumine.xikage.mythicmobs.utils.version.MinecraftVersions;
import io.lumine.xikage.mythicmobs.utils.version.ServerVersion;
import java.awt.Color;
import java.util.Collection;

public class ParticleEffect
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected String strParticle;
    protected String strMob;
    protected BukkitEntityType me;
    protected MythicMob mm;
    protected boolean isMob;
    protected BukkitParticle particle;
    protected Object particleData = null;
    protected SkillAudience audience;
    protected float xSpread;
    protected float zSpread;
    protected float vSpread;
    protected float pSpeed;
    protected float yOffset;
    protected float startForwardOffset;
    protected float startSideOffset;
    protected boolean useEyeLocation;
    protected PlaceholderInt amount;
    protected int viewDistance;
    protected boolean directional;
    protected boolean directionReversed;
    protected AbstractVector direction;
    protected float yaw;
    protected float pitch;
    protected boolean setYaw = false;
    protected boolean setPitch = false;
    protected boolean exactOffsets = false;
    protected Color color = null;
    boolean fromOrigin;

    public ParticleEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        String strColor;
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.ASYNC_ONLY;
        this.strParticle = mlc.getString(new String[]{"particle", "p"}, "reddust", new String[0]);
        this.strMob = mlc.getString(new String[]{"mob", "m", "t"}, "null", new String[0]);
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_15)) {
            if (!this.strParticle.equals("mob")) {
                this.isMob = false;
                this.particle = BukkitParticle.get(this.strParticle);
                if (this.particle.requiresData()) {
                    this.particleData = this.particle.parseDataOptions(mlc);
                }
            } else {
                this.isMob = true;
                this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
                Schedulers.sync().runLater(() -> {
                    this.mm = MythicMobs.inst().getMobManager().getMythicMob(this.strMob);
                    if (this.mm == null) {
                        this.me = BukkitEntityType.getMythicEntity(this.strMob);
                        if (this.me == null) {
                            MythicLogger.errorMechanicConfig(this, mlc, "The 'Mob' attribute must be a valid MythicMob or MythicEntity type.");
                        }
                    }
                }, 1L);
            }
        }
        this.audience = mlc.getAudience("audience", "world");
        this.amount = mlc.getPlaceholderInteger(new String[]{"amount", "a"}, 10, new String[0]);
        float hSpread = mlc.getFloat(new String[]{"hspread", "hs"}, 0.0f);
        this.xSpread = mlc.getFloat(new String[]{"xspread", "xs"}, hSpread);
        this.zSpread = mlc.getFloat(new String[]{"zspread", "zs"}, hSpread);
        this.vSpread = mlc.getFloat(new String[]{"vspread", "vs", "yspread", "ys"}, 0.0f);
        this.pSpeed = mlc.getFloat(new String[]{"speed", "s"}, 0.0f);
        this.yOffset = mlc.getFloat(new String[]{"yoffset", "y"}, 0.0f);
        this.startForwardOffset = mlc.getFloat(new String[]{"forwardoffset", "startfoffset", "sfo"}, 0.0f);
        this.startSideOffset = mlc.getFloat(new String[]{"sideoffset", "soffset", "sso"}, 0.0f);
        this.useEyeLocation = mlc.getBoolean(new String[]{"useeyelocation", "uel"}, false);
        this.exactOffsets = mlc.getBoolean(new String[]{"exactoffsets", "eo"}, false);
        this.viewDistance = mlc.getInteger(new String[]{"viewdistance", "vd"}, 128);
        this.fromOrigin = mlc.getBoolean(new String[]{"fromorigin", "fo"}, false);
        this.directional = mlc.getBoolean(new String[]{"directional", "d"}, false);
        this.directionReversed = mlc.getBoolean(new String[]{"directionreversed", "dr"}, false);
        String direction = mlc.getString(new String[]{"direction", "dir"}, null, new String[0]);
        if (direction == null) {
            this.direction = null;
        } else {
            try {
                String[] split = direction.split(",");
                double dx = Double.parseDouble(split[0]);
                double dy = Double.parseDouble(split[1]);
                double dz = Double.parseDouble(split[2]);
                this.direction = new AbstractVector(dx, dy, dz);
            }
            catch (Error | Exception ex) {
                MythicLogger.errorMechanicConfig(this, mlc, "Invalid format for direction: must be x,y,z vector");
            }
        }
        this.yaw = mlc.getFloat(new String[]{"fixedyaw", "yaw"}, -1111.0f);
        if (this.yaw != -1111.0f) {
            this.setYaw = true;
        }
        this.pitch = mlc.getFloat(new String[]{"fixedpitch", "pitch"}, -1111.0f);
        if (this.pitch != -1111.0f) {
            this.setPitch = true;
        }
        this.color = (strColor = mlc.getString(new String[]{"color", "c"}, null, new String[0])) == null ? null : Color.decode(strColor);
        this.startForwardOffset *= -1.0f;
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        Collection<AbstractEntity> audience = this.audience.get(data, null);
        this.playEffect(data, target, audience);
        return true;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        AbstractLocation startLocation = this.useEyeLocation ? target.getEyeLocation() : target.getLocation();
        Collection<AbstractEntity> audience = this.audience.get(data, target);
        this.playEffect(data, startLocation, audience);
        return true;
    }

    protected void playEffect(SkillMetadata data, AbstractLocation target, Collection<AbstractEntity> audience) {
        if (this.setYaw) {
            target.setYaw(this.yaw);
        }
        if (this.setPitch) {
            target.setPitch(this.pitch);
        }
        if (this.startForwardOffset != 0.0f) {
            target = MythicUtil.move(target, this.startForwardOffset, 0.0, 0.0);
        }
        if (this.startSideOffset != 0.0f) {
            target = MythicUtil.move(target, 0.0, 0.0, this.startSideOffset);
        }
        if (this.directional) {
            this.playDirectionalParticleEffect(data, data.getOrigin(), target, audience);
        } else {
            this.playParticleEffect(data, target, audience);
        }
    }

    protected void playParticleEffect(SkillMetadata data, AbstractLocation target, Collection<AbstractEntity> audience) {
        AbstractLocation ln = target.clone().add(0.0, this.yOffset, 0.0);
        if (!this.isMob) {
            if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_15)) {
                if (this.particleData == null) {
                    if (this.color != null) {
                        this.particle.sendLegacyColored(audience, ln, this.pSpeed, this.amount.get(data), this.xSpread, this.vSpread, this.zSpread, this.color);
                    } else {
                        this.particle.send(audience, ln, this.pSpeed, this.amount.get(data), this.xSpread, this.vSpread, this.zSpread);
                    }
                } else {
                    this.particle.send(audience, ln, this.pSpeed, this.amount.get(data), this.xSpread, this.vSpread, this.zSpread, this.particleData, this.exactOffsets);
                }
            } else {
                if (this.color != null) {
                    this.playColoredParticleEffect(data, target, audience);
                    return;
                }
                new ParticleMaker.ParticlePacket(this.strParticle, this.xSpread, this.vSpread, this.zSpread, this.pSpeed, this.amount.get(data), true).send(ln, this.viewDistance);
            }
        } else {
            ln.add(Math.random() * (double)this.xSpread * 2.0 - (double)this.xSpread, Math.random() * (double)this.vSpread * 2.0 - (double)this.vSpread, Math.random() * (double)this.zSpread * 2.0 - (double)this.zSpread);
            Schedulers.sync().run(() -> MythicMobs.inst().getMobManager().spawnMob(this.strMob, ln));
        }
    }

    protected void playColoredParticleEffect(SkillMetadata data, AbstractLocation target, Collection<AbstractEntity> audience) {
        int amount = this.amount.get(data);
        for (int i = 0; i < amount; ++i) {
            AbstractLocation ln = target.clone().add((double)(0.0f - this.xSpread) + Numbers.randomDouble() * (double)this.xSpread * 2.0, (double)(this.yOffset - this.vSpread) + Numbers.randomDouble() * (double)this.vSpread * 2.0, (double)(0.0f - this.zSpread) + Numbers.randomDouble() * (double)this.zSpread * 2.0);
            new ParticleMaker.ParticlePacket(this.strParticle, this.color, this.pSpeed, 1, true).send(ln, this.viewDistance);
        }
    }

    protected void playDirectionalParticleEffect(SkillMetadata data, AbstractLocation origin, AbstractLocation target, Collection<AbstractEntity> audience) {
        AbstractVector direction = this.direction != null ? this.direction : (this.directionReversed ? origin.toVector().subtract(target.clone().toVector()).normalize() : target.toVector().subtract(origin.clone().toVector()).normalize());
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_15)) {
            if (this.particleData == null) {
                this.particle.sendDirectional(audience, origin, this.pSpeed, this.amount.get(data), this.xSpread, this.vSpread, this.zSpread, direction);
            }
        } else {
            int amount = this.amount.get(data);
            for (int i = 0; i < amount; ++i) {
                AbstractLocation ln = target.clone().add((double)(0.0f - this.xSpread) + Numbers.randomDouble() * (double)this.xSpread * 2.0, (double)(this.yOffset - this.vSpread) + Numbers.randomDouble() * (double)this.vSpread * 2.0, (double)(0.0f - this.zSpread) + Numbers.randomDouble() * (double)this.zSpread * 2.0);
                new ParticleMaker.ParticlePacket(this.strParticle, direction, this.pSpeed, 1, true).send(ln, this.viewDistance);
            }
        }
    }
}

