/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractVector;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.items.MythicItem;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.IParentSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.auras.Aura;
import io.lumine.xikage.mythicmobs.skills.projectiles.Projectile;
import io.lumine.xikage.mythicmobs.skills.projectiles.ProjectileHitBox;
import io.lumine.xikage.mythicmobs.util.VectorUtils;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.items.ItemFactory;
import io.lumine.xikage.mythicmobs.utils.version.MinecraftVersions;
import io.lumine.xikage.mythicmobs.utils.version.ServerVersion;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;

@MythicMechanic(author="Ashijin", name="orbital", aliases={"o"}, description="Applies an orbital aura to the target")
public class OrbitalMechanic
extends Aura
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    public static final Set<AbstractEntity> BULLET_ENTITIES = ConcurrentHashMap.newKeySet();
    protected float radius;
    protected float hitRadius;
    protected float verticalHitRadius;
    protected int points;
    protected int interval;
    protected int iterations;
    protected double velocity = 1.0;
    protected boolean rotate = false;
    protected int startingStep = 0;
    protected double xRotation = 0.0;
    protected double yRotation = 0.0;
    protected double zRotation = 0.0;
    protected double angularVelocityX = 0.015707963267948967;
    protected double angularVelocityY = 0.018479956785822312;
    protected double angularVelocityZ = 0.02026833970057931;
    protected double xOffset = 0.0;
    protected double yOffset = 0.0;
    protected double zOffset = 0.0;
    protected Optional<Skill> onHitSkill = Optional.empty();
    protected String onHitSkillName;
    protected boolean hitSelf = false;
    protected boolean hitPlayers = true;
    protected boolean hitNonPlayers = false;
    protected BulletType bulletType;
    protected Material bulletMaterial = null;
    protected int bulletModelId = 0;
    protected MythicItem bulletMythicItem = null;
    protected Projectile bulletProjectile = null;
    protected MythicMob bulletMob = null;
    protected float bulletSpin = 0.0f;

    public OrbitalMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.radius = mlc.getFloat(new String[]{"radius", "r"}, 4.0f);
        this.hitRadius = mlc.getFloat(new String[]{"hitradius", "hr"}, 1.0f);
        this.verticalHitRadius = mlc.getFloat(new String[]{"verticalhitradius", "vhr", "vr"}, this.hitRadius);
        this.points = mlc.getInteger(new String[]{"points", "p"}, 32);
        this.startingStep = mlc.getInteger(new String[]{"startingPoint", "sp"}, 0);
        this.xRotation = mlc.getDouble(new String[]{"rotationx", "rotx", "rx"}, 0.0);
        this.yRotation = mlc.getDouble(new String[]{"rotationy", "roty", "ry"}, 0.0);
        this.zRotation = mlc.getDouble(new String[]{"rotationz", "rotz", "rz"}, 0.0);
        this.xOffset = mlc.getDouble(new String[]{"offsetx", "offx", "ox"}, 0.0);
        this.yOffset = mlc.getDouble(new String[]{"offsety", "offy", "oy"}, 0.0);
        this.zOffset = mlc.getDouble(new String[]{"offsetz", "offz", "oz"}, 0.0);
        this.angularVelocityX = mlc.getDouble(new String[]{"angularvelocityx", "avx", "vx"}, 0.0);
        this.angularVelocityY = mlc.getDouble(new String[]{"angularvelocityy", "avy", "vy"}, 0.0);
        this.angularVelocityZ = mlc.getDouble(new String[]{"angularvelocityz", "avz", "vz"}, 0.0);
        this.angularVelocityX = this.angularVelocityX == 0.0 ? 0.0 : Math.PI / this.angularVelocityX;
        this.angularVelocityY = this.angularVelocityY == 0.0 ? 0.0 : Math.PI / this.angularVelocityY;
        this.angularVelocityZ = this.angularVelocityZ == 0.0 ? 0.0 : Math.PI / this.angularVelocityZ;
        this.rotate = mlc.getBoolean(new String[]{"rotate"}, this.angularVelocityX > 0.0 || this.angularVelocityY > 0.0 || this.angularVelocityZ > 0.0);
        this.hitSelf = mlc.getBoolean(new String[]{"hitself", "hs"}, false);
        this.hitPlayers = mlc.getBoolean(new String[]{"hitplayers", "hp"}, true);
        this.hitNonPlayers = mlc.getBoolean(new String[]{"hitnonplayers", "hnp"}, false);
        this.onHitSkillName = mlc.getString(new String[]{"onhitskill", "onhit", "oh"});
        String bulletType = mlc.getString(new String[]{"bullettype", "bullet", "b"}, "NONE", new String[0]);
        try {
            this.bulletType = BulletType.valueOf(bulletType.toUpperCase());
        }
        catch (Exception ex) {
            MythicLogger.errorMechanicConfig(this, mlc, "Invalid bullet type specified");
            this.bulletType = BulletType.NONE;
        }
        switch (this.bulletType) {
            case BLOCK: 
            case ITEM: 
            case SMALLBLOCK: {
                String strBulletMaterial = mlc.getString(new String[]{"bulletmaterial", "material", "mat"}, "STONE", new String[0]);
                try {
                    this.bulletMaterial = Material.valueOf((String)strBulletMaterial.toUpperCase());
                    this.bulletModelId = mlc.getInteger(new String[]{"bulletmodel", "model"}, 0);
                }
                catch (Exception ex) {
                    MythicLogger.errorMechanicConfig(this, mlc, "Specified bullet material does not exist");
                    this.bulletMaterial = Material.STONE;
                }
                break;
            }
            case MYTHICITEM: {
                String strMythicItem = mlc.getString(new String[]{"bulletmaterial", "material", "mat"}, "STONE", new String[0]);
                Optional<MythicItem> maybeItem = MythicMobs.inst().getItemManager().getItem(strMythicItem);
                maybeItem.ifPresent(mythicItem -> {
                    this.bulletMythicItem = mythicItem;
                });
                break;
            }
        }
        this.bulletSpin = mlc.getFloat(new String[]{"bulletspin", "bspin"}, 0.0f);
        OrbitalMechanic.getPlugin().getSkillManager().queueSecondPass(() -> {
            if (this.onHitSkillName != null) {
                this.onHitSkill = MythicMobs.inst().getSkillManager().getSkill(this.onHitSkillName);
            }
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Loaded orbital onHit pointing at " + this.onHitSkillName, new Object[0]);
        });
        Schedulers.sync().runLater(() -> {
            if (this.bulletType == BulletType.MOB) {
                String mobType = mlc.getString(new String[]{"mob", "mobtype", "mm"}, "SkeletalKnight", new String[0]);
                this.bulletMob = OrbitalMechanic.getPlugin().getMobManager().getMythicMob(mobType);
                if (this.bulletMob == null) {
                    MythicLogger.errorMechanicConfig(this, mlc, "Invalid bullet mob type " + mobType + " specified");
                    this.bulletType = BulletType.NONE;
                }
            }
        }, 5L);
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        new OrbitalTracker(data, target);
        return true;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        new OrbitalTracker(data, target);
        return true;
    }

    protected static enum BulletType {
        NONE,
        ITEM,
        BLOCK,
        SMALLBLOCK,
        MYTHICITEM,
        ARMOR_STAND,
        ARROW,
        MOB;

    }

    public class OrbitalTracker
    extends Aura.AuraTracker
    implements IParentSkill,
    Runnable {
        private float radius;
        private float power;
        private int iteration;
        private int step;
        protected AbstractLocation previousLocation;
        protected AbstractEntity bullet;
        private Set<AbstractEntity> inRange;
        private HashSet<AbstractEntity> targets;
        private Map<AbstractEntity, Long> immune;

        public OrbitalTracker(SkillMetadata data, AbstractEntity entity) {
            super((Aura)OrbitalMechanic.this, entity, data);
            this.iteration = 0;
            this.step = 0;
            this.bullet = null;
            this.inRange = ConcurrentHashMap.newKeySet();
            this.targets = new HashSet();
            this.immune = new HashMap<AbstractEntity, Long>();
            this.step = OrbitalMechanic.this.startingStep;
            this.radius = OrbitalMechanic.this.radius;
            this.power = data.getPower();
            this.start();
        }

        public OrbitalTracker(SkillMetadata data, AbstractLocation location) {
            super((Aura)OrbitalMechanic.this, location, data);
            this.iteration = 0;
            this.step = 0;
            this.bullet = null;
            this.inRange = ConcurrentHashMap.newKeySet();
            this.targets = new HashSet();
            this.immune = new HashMap<AbstractEntity, Long>();
            this.step = OrbitalMechanic.this.startingStep;
            this.radius = OrbitalMechanic.this.radius;
            this.power = data.getPower();
            this.start();
        }

        public AbstractLocation getLocation() {
            if (this.entity.isPresent()) {
                return ((AbstractEntity)this.entity.get()).getLocation().add(OrbitalMechanic.this.xOffset, OrbitalMechanic.this.yOffset, OrbitalMechanic.this.zOffset);
            }
            if (this.location.isPresent()) {
                return ((AbstractLocation)this.location.get()).clone().add(OrbitalMechanic.this.xOffset, OrbitalMechanic.this.yOffset, OrbitalMechanic.this.zOffset);
            }
            return null;
        }

        @Override
        public void auraStart() {
            if (OrbitalMechanic.this.hitSelf || OrbitalMechanic.this.hitPlayers || OrbitalMechanic.this.hitNonPlayers) {
                this.inRange.addAll(AbstractSkill.getPlugin().getEntityManager().getLivingEntities(this.skillMetadata.getOrigin().getWorld()));
                this.inRange.removeIf(e -> {
                    if (e != null) {
                        if (!OrbitalMechanic.this.hitSelf && e.getUniqueId().equals(this.skillMetadata.getCaster().getEntity().getUniqueId())) {
                            return true;
                        }
                        if (!OrbitalMechanic.this.hitPlayers && e.isPlayer()) {
                            return true;
                        }
                        return !OrbitalMechanic.this.hitNonPlayers && !e.isPlayer();
                    }
                    return true;
                });
            }
            if (this.previousLocation == null) {
                this.previousLocation = this.getLocation();
            }
            this.spawnBullet();
            this.executeAuraSkill(OrbitalMechanic.this.onStartSkill, this.skillMetadata.deepClone().setOrigin(this.previousLocation));
        }

        @Override
        public void auraTick() {
            if (this.previousLocation == null) {
                this.previousLocation = this.getLocation();
            }
            AbstractLocation location = this.getLocation();
            double inc = Math.PI * 2 / (double)OrbitalMechanic.this.points;
            double angle = (double)this.step * inc;
            AbstractVector v = new AbstractVector(0, 0, 0);
            v.setX(Math.cos(angle) * (double)this.radius);
            v.setZ(Math.sin(angle) * (double)this.radius);
            VectorUtils.rotateVector(v, OrbitalMechanic.this.xRotation, OrbitalMechanic.this.yRotation, OrbitalMechanic.this.zRotation);
            if (OrbitalMechanic.this.rotate) {
                VectorUtils.rotateVector(v, OrbitalMechanic.this.angularVelocityX * (double)this.step, OrbitalMechanic.this.angularVelocityY * (double)this.step, OrbitalMechanic.this.angularVelocityZ * (double)this.step);
            }
            location = location.add(v);
            this.executeAuraSkill(OrbitalMechanic.this.onTickSkill, this.skillMetadata.deepClone().setOrigin(location));
            AbstractLocation fLocation = location;
            Schedulers.sync().run(() -> {
                if (this.bullet != null) {
                    if (OrbitalMechanic.this.bulletType == BulletType.ITEM) {
                        AbstractLocation ol = this.previousLocation.clone().subtract(0.0, 0.35, 0.0);
                        AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().setItemPosition(this.bullet, ol);
                        this.bullet.setVelocity(fLocation.toVector().subtract(this.previousLocation.toVector()));
                    } else if (OrbitalMechanic.this.bulletType == BulletType.ARROW) {
                        this.bullet.setVelocity(fLocation.toVector().subtract(this.bullet.getLocation().clone().toVector()).multiply(0.25));
                    } else if (OrbitalMechanic.this.bulletType == BulletType.MOB) {
                        AbstractLocation ol = this.previousLocation.clone().subtract(0.0, 1.35, 0.0);
                        if (OrbitalMechanic.this.bulletSpin != 0.0f) {
                            float newSpin = this.bullet.getLocation().getYaw() + OrbitalMechanic.this.bulletSpin;
                            ol.setYaw(newSpin);
                        }
                        this.bullet.teleport(ol);
                    } else {
                        this.bullet.setVelocity(fLocation.toVector().subtract(this.bullet.getLocation().clone().toVector()).multiply(1));
                        if (OrbitalMechanic.this.bulletSpin > 0.0f) {
                            float newSpin = this.bullet.getLocation().getYaw() + OrbitalMechanic.this.bulletSpin;
                            AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().setEntityRotation(this.bullet, newSpin, newSpin);
                        }
                    }
                }
            });
            if (this.inRange != null) {
                ProjectileHitBox hitBox = new ProjectileHitBox(location, OrbitalMechanic.this.hitRadius, OrbitalMechanic.this.verticalHitRadius);
                for (AbstractEntity e : this.inRange) {
                    if (e.isDead() || !hitBox.contains(e.getLocation().add(0.0, 0.6, 0.0))) continue;
                    this.targets.add(e);
                    this.immune.put(e, System.currentTimeMillis());
                    break;
                }
                this.immune.entrySet().removeIf(entry -> (Long)entry.getValue() < System.currentTimeMillis() - 2000L);
                if (this.targets.size() > 0) {
                    if (OrbitalMechanic.this.onHitSkill.isPresent()) {
                        SkillMetadata sData = this.skillMetadata.deepClone();
                        sData.setEntityTargets((HashSet)this.targets.clone());
                        sData.setOrigin(location.clone());
                        if (OrbitalMechanic.this.onHitSkill.get().isUsable(sData)) {
                            OrbitalMechanic.this.onHitSkill.get().execute(sData);
                        }
                    }
                    this.targets.clear();
                    this.consumeCharge();
                }
            }
            ++this.step;
            this.previousLocation = location;
        }

        @Override
        public void auraStop() {
            this.executeAuraSkill(OrbitalMechanic.this.onEndSkill, this.skillMetadata.deepClone().setOrigin(this.previousLocation));
            if (OrbitalMechanic.this.bulletType != BulletType.NONE) {
                Schedulers.sync().runLater(() -> {
                    if (this.bullet != null) {
                        this.bullet.remove();
                        BULLET_ENTITIES.remove(this.bullet);
                    }
                }, 2L);
            }
        }

        private void spawnBullet() {
            if (OrbitalMechanic.this.bulletType == BulletType.BLOCK) {
                Schedulers.sync().run(() -> {
                    if (this.hasTerminated()) {
                        return;
                    }
                    AbstractLocation l = this.getLocation().clone().subtract(0.0, 0.5, 0.0);
                    FallingBlock block = ServerVersion.isAfterOrEq(MinecraftVersions.v1_15) ? BukkitAdapter.adapt(l).getWorld().spawnFallingBlock(BukkitAdapter.adapt(l), OrbitalMechanic.this.bulletMaterial.createBlockData()) : BukkitAdapter.adapt(l).getWorld().spawnFallingBlock(BukkitAdapter.adapt(l), OrbitalMechanic.this.bulletMaterial, (byte)0);
                    block.setHurtEntities(false);
                    block.setDropItem(false);
                    block.setTicksLived(Integer.MAX_VALUE);
                    block.setInvulnerable(true);
                    block.setGravity(false);
                    this.bullet = BukkitAdapter.adapt((Entity)block);
                    BULLET_ENTITIES.add(this.bullet);
                    AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().setHitBox(this.bullet, 0.0, 0.0, 0.0);
                    if (this.hasTerminated()) {
                        block.remove();
                    }
                });
            } else if (OrbitalMechanic.this.bulletType == BulletType.MYTHICITEM) {
                Schedulers.sync().run(() -> {
                    ItemStack i = BukkitAdapter.adapt(OrbitalMechanic.this.bulletMythicItem.generateItemStack(1));
                    AbstractLocation l = this.getLocation().clone().subtract(0.0, 0.35, 0.0);
                    Item item = BukkitAdapter.adapt(l).getWorld().dropItem(BukkitAdapter.adapt(l), i);
                    item.setTicksLived(Integer.MAX_VALUE);
                    item.setInvulnerable(true);
                    item.setGravity(false);
                    item.setPickupDelay(Integer.MAX_VALUE);
                    this.bullet = BukkitAdapter.adapt((Entity)item);
                    BULLET_ENTITIES.add(this.bullet);
                    AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().setItemPosition(this.bullet, l);
                    AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().sendEntityTeleportPacket(this.bullet);
                    AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().setHitBox(this.bullet, 0.0, 0.0, 0.0);
                    if (this.hasTerminated()) {
                        item.remove();
                    }
                });
            } else if (OrbitalMechanic.this.bulletType == BulletType.SMALLBLOCK) {
                Schedulers.sync().run(() -> {
                    AbstractLocation l = this.getLocation().clone();
                    ArmorStand block = (ArmorStand)BukkitAdapter.adapt(l).getWorld().spawnEntity(BukkitAdapter.adapt(l), EntityType.ARMOR_STAND);
                    block.setCustomName("Dinnerbone");
                    block.setCustomNameVisible(false);
                    block.setHeadPose(new EulerAngle(0.0, 0.0, 0.0));
                    block.getEquipment().setHelmet(new ItemStack(OrbitalMechanic.this.bulletMaterial));
                    block.setArms(false);
                    block.setBasePlate(false);
                    block.setVisible(false);
                    block.setTicksLived(Integer.MAX_VALUE);
                    block.setInvulnerable(true);
                    this.bullet = BukkitAdapter.adapt((Entity)block);
                    AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().setArmorStandNoGravity(this.bullet);
                    BULLET_ENTITIES.add(this.bullet);
                    AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().setHitBox(this.bullet, 0.0, 0.0, 0.0);
                    if (this.hasTerminated()) {
                        block.remove();
                    }
                });
            } else if (OrbitalMechanic.this.bulletType == BulletType.ITEM) {
                Schedulers.sync().run(() -> {
                    ItemStack i = ItemFactory.of(OrbitalMechanic.this.bulletMaterial).model(OrbitalMechanic.this.bulletModelId).build();
                    AbstractLocation l = this.getLocation().clone().subtract(0.0, 0.35, 0.0);
                    Item item = BukkitAdapter.adapt(l).getWorld().dropItem(BukkitAdapter.adapt(l), i);
                    item.setTicksLived(Integer.MAX_VALUE);
                    item.setInvulnerable(true);
                    item.setGravity(false);
                    item.setPickupDelay(Integer.MAX_VALUE);
                    this.bullet = BukkitAdapter.adapt((Entity)item);
                    BULLET_ENTITIES.add(this.bullet);
                    AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().setItemPosition(this.bullet, l);
                    AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().sendEntityTeleportPacket(this.bullet);
                    AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().setHitBox(this.bullet, 0.0, 0.0, 0.0);
                    if (this.hasTerminated()) {
                        item.remove();
                    }
                });
            } else if (OrbitalMechanic.this.bulletType == BulletType.MOB && OrbitalMechanic.this.bulletMob != null) {
                Schedulers.sync().runLater(() -> {
                    AbstractLocation l = this.previousLocation.clone().subtract(0.0, 1.35, 0.0);
                    ActiveMob am = OrbitalMechanic.this.bulletMob.spawn(l, 1.0, SpawnReason.OTHER);
                    Entity entity = am.getEntity().getBukkitEntity();
                    am.setParent(this.skillMetadata.getCaster());
                    am.setOwner(this.skillMetadata.getCaster().getEntity().getUniqueId());
                    entity.setTicksLived(Integer.MAX_VALUE);
                    entity.setInvulnerable(true);
                    this.bullet = BukkitAdapter.adapt(entity);
                    BULLET_ENTITIES.add(this.bullet);
                    if (entity.getType().equals((Object)EntityType.ARMOR_STAND)) {
                        AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().setArmorStandNoGravity(this.bullet);
                        this.bullet.setAI(true);
                        ((ArmorStand)entity).setRemoveWhenFarAway(true);
                    } else {
                        entity.setGravity(false);
                        if (entity instanceof LivingEntity) {
                            ((LivingEntity)entity).setRemoveWhenFarAway(true);
                        }
                    }
                    AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().setHitBox(this.bullet, 0.0, 0.0, 0.0);
                    if (this.hasTerminated()) {
                        this.bullet.remove();
                    }
                }, 2L);
            }
        }

        public void setRadius(float p) {
            this.radius = p;
        }

        public void modifyRadius(float p) {
            this.radius *= p;
        }
    }
}

