/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitTriggerMetadata;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.IParentSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.auras.Aura;
import io.lumine.xikage.mythicmobs.skills.damage.DamageMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderDouble;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.Events;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;

@MythicMechanic(author="Ashijin", name="ondamaged", description="Applies an aura to the target that triggers a skill when they take damage")
public class OnDamagedMechanic
extends Aura
implements ITargetedEntitySkill {
    protected Optional<Skill> onDamagedSkill = Optional.empty();
    protected String onAttackSkillName;
    @MythicField(name="cancelEvent", aliases={"ce"}, defValue="false", version="4.6", description="Whether or not to cancel the event that triggered the aura")
    protected boolean cancelDamage;
    protected boolean modDamage = false;
    @MythicField(name="damageSub", aliases={"s"}, defValue="0", version="4.6", description="")
    protected PlaceholderDouble damageSub;
    @MythicField(name="damageMultiplier", aliases={"m"}, defValue="1", version="4.6", description="")
    protected PlaceholderDouble damageMult;
    private Map<String, Double> damageModifiers = new HashMap<String, Double>();

    public OnDamagedMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.onAttackSkillName = mlc.getString(new String[]{"ondamagedskill", "ondamaged", "od", "onhitskill", "onhit", "oh"});
        this.cancelDamage = mlc.getBoolean(new String[]{"cancelevent", "ce", "canceldamage", "cd"}, false);
        String damageSub = mlc.getString(new String[]{"damagesub", "sub", "s"}, null, new String[0]);
        String damageMult = mlc.getString(new String[]{"damagemultiplier", "multiplier", "m"}, null, new String[0]);
        this.damageSub = damageSub == null ? PlaceholderDouble.of("0") : PlaceholderDouble.of(damageSub);
        this.damageMult = damageMult == null ? PlaceholderDouble.of("1") : PlaceholderDouble.of(damageMult);
        PlaceholderString strDamageMod = mlc.getPlaceholderString(new String[]{"damagemodifiers", "damagemods", "damagemod"}, null, new String[0]);
        if (strDamageMod != null) {
            String[] lstDamageMod;
            for (String dm : lstDamageMod = strDamageMod.toString().split(",")) {
                try {
                    block7: {
                        try {
                            if (MythicMobs.isVolatile()) break block7;
                            EntityDamageEvent.DamageCause.valueOf((String)dm.toUpperCase());
                        }
                        catch (Error | Exception ex) {
                            MythicLogger.errorMechanicConfig(this, mlc, "Custom damage modifiers require MythicMobs Premium to use.");
                            continue;
                        }
                    }
                    String[] split = dm.split(" ");
                    String type = split[0];
                    double mod = Double.valueOf(split[1]);
                    this.damageModifiers.put(type, mod);
                }
                catch (Exception ex) {
                    MythicLogger.errorMechanicConfig(this, mlc, "Invalid syntax for DamageModifier");
                }
            }
        }
        if (damageSub != null || damageMult != null || this.damageModifiers.size() > 0) {
            this.modDamage = true;
        }
        MythicMobs.inst().getSkillManager().queueSecondPass(() -> {
            if (this.onAttackSkillName != null) {
                this.onDamagedSkill = MythicMobs.inst().getSkillManager().getSkill(this.onAttackSkillName);
            }
        });
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        new Tracker(data, target);
        return true;
    }

    protected double calculateDamage(SkillMetadata meta, AbstractEntity entity, EntityDamageEvent event) {
        DamageMetadata data;
        if (this.cancelDamage) {
            return 0.0;
        }
        double damage = event.getFinalDamage();
        Optional<Object> maybeData = entity.getMetadata("skill-damage");
        String damageType = maybeData.isPresent() ? ((data = (DamageMetadata)maybeData.get()).getElement() == null ? "SKILL" : data.getElement()) : event.getCause().toString();
        double mod = this.damageModifiers.getOrDefault(damageType.toUpperCase(), 1.0);
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura: damageMod {0} has multiplier {1}", damageType, mod);
        return (damage - this.damageSub.get(meta, entity)) * this.damageMult.get(meta, entity) * mod;
    }

    private class Tracker
    extends Aura.AuraTracker
    implements IParentSkill,
    Runnable {
        public Tracker(SkillMetadata data, AbstractEntity entity) {
            super((Aura)OnDamagedMechanic.this, entity, data);
            this.start();
        }

        @Override
        public void auraStart() {
            this.registerAuraComponent(Events.subscribe(EntityDamageByEntityEvent.class, EventPriority.HIGHEST).filter(event -> event.getEntity().getUniqueId().equals(((AbstractEntity)this.entity.get()).getUniqueId())).handler(event -> {
                SkillMetadata meta = this.skillMetadata.deepClone();
                meta.setEntityTarget(BukkitAdapter.adapt(event.getEntity()));
                BukkitTriggerMetadata.apply(meta, (EntityDamageEvent)event);
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura (byEntity) listener called for {0}", ((AbstractEntity)this.entity.get()).getUniqueId());
                if (this.executeAuraSkill(OnDamagedMechanic.this.onDamagedSkill, meta)) {
                    this.consumeCharge();
                    if (OnDamagedMechanic.this.cancelDamage) {
                        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura cancelling damage", new Object[0]);
                        event.setCancelled(true);
                    } else if (OnDamagedMechanic.this.modDamage) {
                        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura modifying damage", new Object[0]);
                        double damage = OnDamagedMechanic.this.calculateDamage(meta, (AbstractEntity)this.entity.get(), (EntityDamageEvent)event);
                        event.setDamage(damage);
                    } else {
                        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura executed", new Object[0]);
                    }
                }
            }));
            this.registerAuraComponent(Events.subscribe(EntityDamageEvent.class, EventPriority.HIGHEST).filter(event -> event.getEntity().getUniqueId().equals(((AbstractEntity)this.entity.get()).getUniqueId())).handler(event -> {
                SkillMetadata meta = this.skillMetadata.deepClone();
                meta.setEntityTarget(BukkitAdapter.adapt(event.getEntity()));
                BukkitTriggerMetadata.apply(meta, event);
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura (nonEntity) listener called for {0}", ((AbstractEntity)this.entity.get()).getUniqueId());
                if (this.executeAuraSkill(OnDamagedMechanic.this.onDamagedSkill, meta)) {
                    this.consumeCharge();
                    if (OnDamagedMechanic.this.cancelDamage) {
                        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura cancelling damage", new Object[0]);
                        event.setCancelled(true);
                    } else if (OnDamagedMechanic.this.modDamage) {
                        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura modifying damage", new Object[0]);
                        double damage = OnDamagedMechanic.this.calculateDamage(meta, (AbstractEntity)this.entity.get(), (EntityDamageEvent)event);
                        event.setDamage(damage);
                    } else {
                        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura executed", new Object[0]);
                    }
                }
            }));
            this.executeAuraSkill(OnDamagedMechanic.this.onStartSkill, this.skillMetadata);
        }
    }
}

