/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitTriggerMetadata;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.IParentSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.auras.Aura;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.Events;
import java.util.Optional;
import org.bukkit.event.block.BlockBreakEvent;

@MythicMechanic(author="Ashijin", name="onblockbreak", aliases={"onbreakblock"}, description="Applies an aura to the target that triggers a skill when they break a block")
public class OnBlockBreakMechanic
extends Aura
implements ITargetedEntitySkill {
    @MythicField(name="onBreak", aliases={"ob"}, version="4.13", description="Skill to execute if the target hits something")
    protected Optional<Skill> onBreakSkill = Optional.empty();
    protected String onBreakSkillName;
    @MythicField(name="cancelEvent", aliases={"ce"}, defValue="false", version="4.13", description="Whether or not to cancel the event that triggered the aura")
    protected boolean cancelEvent;
    protected boolean dropItems = false;

    public OnBlockBreakMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.onBreakSkillName = mlc.getString(new String[]{"onbreakskill", "onbreak", "ob"});
        this.cancelEvent = mlc.getBoolean(new String[]{"cancelevent", "ce", "cancel"}, false);
        MythicMobs.inst().getSkillManager().queueSecondPass(() -> {
            if (this.onBreakSkillName != null) {
                this.onBreakSkill = MythicMobs.inst().getSkillManager().getSkill(this.onBreakSkillName);
            }
        });
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        new Tracker(data, target);
        return true;
    }

    private class Tracker
    extends Aura.AuraTracker
    implements IParentSkill,
    Runnable {
        public Tracker(SkillMetadata data, AbstractEntity entity) {
            super((Aura)OnBlockBreakMechanic.this, entity, data);
            this.start();
        }

        @Override
        public void auraStart() {
            this.registerAuraComponent(Events.subscribe(BlockBreakEvent.class).filter(event -> event.getPlayer().getUniqueId().equals(((AbstractEntity)this.entity.get()).getUniqueId())).handler(event -> {
                SkillMetadata meta = this.skillMetadata.deepClone();
                AbstractLocation target = BukkitAdapter.adapt(event.getBlock().getLocation()).add(0.5, 0.5, 0.5);
                meta.setLocationTarget(target);
                BukkitTriggerMetadata.apply(meta, event);
                if (this.executeAuraSkill(OnBlockBreakMechanic.this.onBreakSkill, meta)) {
                    this.consumeCharge();
                    if (OnBlockBreakMechanic.this.cancelEvent) {
                        event.setCancelled(true);
                    } else if (!OnBlockBreakMechanic.this.dropItems) {
                        event.setDropItems(false);
                    }
                }
            }));
            this.executeAuraSkill(OnBlockBreakMechanic.this.onStartSkill, this.skillMetadata);
        }
    }
}

