/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.IParentSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.auras.Aura;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderDouble;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.Events;
import java.util.Optional;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;

@MythicMechanic(author="Ashijin", name="onattack", aliases={"onhit"}, description="Applies an aura to the target that triggers a skill when they damage something")
public class OnAttackMechanic
extends Aura
implements ITargetedEntitySkill {
    @MythicField(name="onAttack", aliases={"oa"}, version="4.6", description="Skill to execute if the target hits something")
    protected Optional<Skill> onAttackSkill = Optional.empty();
    protected String onAttackSkillName;
    @MythicField(name="cancelEvent", aliases={"ce"}, defValue="false", version="4.6", description="Whether or not to cancel the event that triggered the aura")
    protected boolean cancelDamage;
    protected boolean modDamage = false;
    @MythicField(name="damageAdd", aliases={"a"}, defValue="0", version="4.6", description="")
    protected PlaceholderDouble damageAdd;
    @MythicField(name="damageMultiplier", aliases={"m"}, defValue="1", version="4.6", description="")
    protected PlaceholderDouble damageMult;

    public OnAttackMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.onAttackSkillName = mlc.getString(new String[]{"onattackskill", "onattack", "oa", "onmelee", "onhitskill", "onhit", "oh"});
        this.cancelDamage = mlc.getBoolean(new String[]{"cancelevent", "ce", "canceldamage", "cd"}, false);
        String damageAdd = mlc.getString(new String[]{"damageadd", "add", "a"}, null, new String[0]);
        String damageMult = mlc.getString(new String[]{"damagemultiplier", "multiplier", "m"}, null, new String[0]);
        if (damageAdd != null || damageMult != null) {
            this.modDamage = true;
        }
        this.damageAdd = damageAdd == null ? PlaceholderDouble.of("0") : PlaceholderDouble.of(damageAdd);
        this.damageMult = damageMult == null ? PlaceholderDouble.of("1") : PlaceholderDouble.of(damageMult);
        MythicMobs.inst().getSkillManager().queueSecondPass(() -> {
            if (this.onAttackSkillName != null) {
                this.onAttackSkill = MythicMobs.inst().getSkillManager().getSkill(this.onAttackSkillName);
            }
        });
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        new Tracker(data, target);
        return true;
    }

    protected double calculateDamage(SkillMetadata data, AbstractEntity target, double damage) {
        if (this.cancelDamage) {
            return 0.0;
        }
        return (damage + this.damageAdd.get(data, target)) * this.damageMult.get(data, target);
    }

    private class Tracker
    extends Aura.AuraTracker
    implements IParentSkill,
    Runnable {
        public Tracker(SkillMetadata data, AbstractEntity entity) {
            super((Aura)OnAttackMechanic.this, entity, data);
            this.start();
        }

        @Override
        public void auraStart() {
            this.registerAuraComponent(Events.subscribe(EntityDamageByEntityEvent.class).filter(event -> event.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK).filter(event -> event.getDamager().getUniqueId().equals(((AbstractEntity)this.entity.get()).getUniqueId())).filter(event -> {
                Optional<Object> md = BukkitAdapter.adapt(event.getDamager()).getMetadata("doing-skill-damage");
                if (md.isPresent()) {
                    return (Boolean)md.get() == false;
                }
                return true;
            }).handler(event -> {
                SkillMetadata meta = this.skillMetadata.deepClone();
                AbstractEntity target = BukkitAdapter.adapt(event.getEntity());
                meta.setEntityTarget(target);
                if (this.executeAuraSkill(OnAttackMechanic.this.onAttackSkill, meta)) {
                    this.consumeCharge();
                    if (OnAttackMechanic.this.cancelDamage) {
                        event.setCancelled(true);
                    } else if (OnAttackMechanic.this.modDamage) {
                        double damage = OnAttackMechanic.this.calculateDamage(meta, target, event.getDamage());
                        event.setDamage(damage);
                    }
                }
            }));
            this.executeAuraSkill(OnAttackMechanic.this.onStartSkill, this.skillMetadata);
        }
    }
}

