/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.INoTargetSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="mount", aliases={"vehicle"}, description="Summons a vehicle for the caster")
public class MountMechanic
extends SkillMechanic
implements INoTargetSkill {
    private PlaceholderString strType;

    public MountMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.strType = mlc.getPlaceholderString(new String[]{"mob", "m", "type", "t"}, "", new String[0]);
    }

    @Override
    public boolean cast(SkillMetadata data) {
        MythicMob mount = MountMechanic.getPlugin().getMobManager().getMythicMob(this.strType.get(data));
        if (mount == null) {
            MythicLogger.errorMechanicConfig(this, this.config, "The 'mob' attribute must be a valid MythicMob.");
            return false;
        }
        AbstractEntity me = mount.spawn(data.getCaster().getEntity().getLocation(), data.getCaster().getLevel(), SpawnReason.SUMMON).getEntity();
        if (me == null) {
            return false;
        }
        me.setPassenger(data.getCaster().getEntity());
        MountMechanic.getPlugin().getMobManager().getActiveMob(me.getUniqueId()).get().setOwner(data.getCaster().getEntity().getUniqueId());
        MountMechanic.getPlugin().getMobManager().getActiveMob(me.getUniqueId()).get().setParent(data.getCaster());
        return true;
    }
}

