/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.INoTargetSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import org.bukkit.Bukkit;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;

@MythicMechanic(author="Ashijin", name="modifyscore", description="Modifies a scoreboard value")
public class ModifyScoreMechanic
extends SkillMechanic
implements INoTargetSkill {
    protected PlaceholderString entry;
    protected PlaceholderString objective;
    protected ModifyScoreAction action;
    protected PlaceholderString value;

    public ModifyScoreMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.entry = PlaceholderString.of(mlc.getString(new String[]{"entry", "e", "name", "n"}, "dummy", new String[0]));
        this.objective = PlaceholderString.of(mlc.getString(new String[]{"objective", "obj", "o"}, "", new String[0]));
        this.value = PlaceholderString.of(mlc.getString(new String[]{"value", "v"}, "0", new String[0]));
        String strAction = mlc.getString(new String[]{"action", "a"}, "SET", new String[0]);
        try {
            this.action = ModifyScoreAction.valueOf(strAction.toUpperCase());
        }
        catch (Exception ex) {
            this.action = ModifyScoreAction.SET;
        }
    }

    @Override
    public boolean cast(SkillMetadata data) {
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        String fentry = this.entry.get(data);
        String fobjective = this.objective.get(data);
        int fvalue = Integer.valueOf(this.value.get(data));
        Objective objective = scoreboard.getObjective(fobjective);
        if (objective == null) {
            objective = scoreboard.registerNewObjective(fobjective, "dummy");
        }
        if (this.action != ModifyScoreAction.UNSET) {
            Score score = objective.getScore(fentry);
            score.setScore(this.applyModifier(score.getScore(), fvalue));
        }
        return true;
    }

    protected int applyModifier(int score, int value) {
        if (this.action == ModifyScoreAction.SET) {
            score = value;
        } else if (this.action == ModifyScoreAction.ADD) {
            score += value;
        } else if (this.action == ModifyScoreAction.SUBTRACT) {
            score -= value;
        } else if (this.action == ModifyScoreAction.MULTIPLY) {
            score *= value;
        } else if (this.action == ModifyScoreAction.DIVIDE) {
            score /= value;
        } else if (this.action == ModifyScoreAction.MOD) {
            score %= value;
        }
        return score;
    }

    protected static enum ModifyScoreAction {
        SET,
        ADD,
        SUBTRACT,
        MULTIPLY,
        DIVIDE,
        MOD,
        UNSET;

    }
}

