/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.INoTargetSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.mechanics.MissileMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.OrbitalMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.ProjectileMechanic;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="modifyprojectile", description="Modifies an attribute of the projectile that executed the mechanic")
public class ModifyProjectileMechanic
extends SkillMechanic
implements INoTargetSkill {
    private ProjectileTrait trait;
    private ModifyAction action;
    private double value;

    public ModifyProjectileMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        String t = mlc.getString(new String[]{"trait", "t"}, "VELOCITY", new String[0]);
        try {
            this.trait = ProjectileTrait.valueOf(t.toUpperCase());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String a = mlc.getString(new String[]{"action", "a"}, "MULTIPLY", new String[0]);
        try {
            this.action = ModifyAction.valueOf(a.toUpperCase());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.value = mlc.getDouble(new String[]{"value", "v"}, 0.0);
    }

    @Override
    public boolean cast(SkillMetadata data) {
        if (data.getCallingEvent() instanceof ProjectileMechanic.ProjectileMechanicTracker) {
            ProjectileMechanic.ProjectileMechanicTracker projectile = (ProjectileMechanic.ProjectileMechanicTracker)data.getCallingEvent();
            if (this.action == ModifyAction.SET) {
                switch (this.trait) {
                    case VELOCITY: {
                        projectile.setVelocity(this.value);
                        break;
                    }
                    case POWER: {
                        projectile.setPower((float)this.value);
                        break;
                    }
                    case GRAVITY: {
                        projectile.setGravity((float)this.value);
                        break;
                    }
                }
            } else {
                switch (this.trait) {
                    case VELOCITY: {
                        projectile.modifyVelocity(this.value);
                        break;
                    }
                    case POWER: {
                        projectile.modifyPower((float)this.value);
                        break;
                    }
                    case GRAVITY: {
                        projectile.modifyGravity((float)this.value);
                        break;
                    }
                }
            }
        } else if (data.getCallingEvent() instanceof MissileMechanic.MissileTracker) {
            MissileMechanic.MissileTracker projectile = (MissileMechanic.MissileTracker)data.getCallingEvent();
            if (this.action == ModifyAction.SET) {
                switch (this.trait) {
                    case VELOCITY: {
                        projectile.setVelocity(this.value);
                        break;
                    }
                    case POWER: {
                        projectile.setPower((float)this.value);
                        break;
                    }
                    case INERTIA: {
                        projectile.setInertia((float)this.value);
                        break;
                    }
                }
            } else {
                switch (this.trait) {
                    case VELOCITY: {
                        projectile.modifyVelocity(this.value);
                        break;
                    }
                    case POWER: {
                        projectile.modifyPower((float)this.value);
                        break;
                    }
                    case INERTIA: {
                        projectile.modifyInertia((float)this.value);
                        break;
                    }
                }
            }
        } else if (data.getCallingEvent() instanceof OrbitalMechanic.OrbitalTracker) {
            OrbitalMechanic.OrbitalTracker projectile = (OrbitalMechanic.OrbitalTracker)data.getCallingEvent();
            if (this.action == ModifyAction.SET) {
                switch (this.trait) {
                    case RADIUS: {
                        projectile.setRadius((float)this.value);
                        break;
                    }
                    case POWER: {
                        break;
                    }
                }
            } else {
                switch (this.trait) {
                    case RADIUS: {
                        projectile.modifyRadius((float)this.value);
                        break;
                    }
                    case POWER: {
                        break;
                    }
                }
            }
        }
        return true;
    }

    private static enum ProjectileTrait {
        INERTIA,
        GRAVITY,
        POWER,
        VELOCITY,
        RADIUS;

    }

    private static enum ModifyAction {
        MULTIPLY,
        SET;

    }
}

