/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractVector;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.projectiles.Projectile;
import io.lumine.xikage.mythicmobs.util.BlockUtil;
import io.lumine.xikage.mythicmobs.util.MythicUtil;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.numbers.Numbers;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

@MythicMechanic(author="Ashijin", name="missile", aliases={"mi"}, description="Shoots a homing missile at the target")
public class MissileMechanic
extends Projectile
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected float projectileInertia;

    public MissileMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.hitNonPlayers = mlc.getBoolean(new String[]{"hitnonplayers", "hnp"}, true);
        this.projectileInertia = mlc.getFloat(new String[]{"intertia", "inertia", "in"}, 1.5f);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        try {
            new MissileTracker(data, target).start();
            return true;
        }
        catch (Exception ex) {
            MythicLogger.error("An error occurred executing a Missile Mechanic", ex);
            return false;
        }
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        try {
            new MissileTracker(data, target).start();
            return true;
        }
        catch (Exception ex) {
            MythicLogger.error("An error occurred executing a Missile Mechanic", ex);
            return false;
        }
    }

    public class MissileTracker
    extends Projectile.ProjectileTracker {
        protected float inertia;
        protected AbstractEntity target;
        protected AbstractLocation targetLocation;
        protected float velocity;
        protected double targetYOffset;

        public MissileTracker(SkillMetadata data, AbstractEntity target) {
            super(MissileMechanic.this, data, target.getLocation());
            this.target = null;
            this.targetLocation = null;
            this.target = target;
            this.targetLocation = target.getLocation();
            this.inertia = MissileMechanic.this.projectileInertia;
        }

        public MissileTracker(SkillMetadata data, AbstractLocation target) {
            super(MissileMechanic.this, data, target);
            this.target = null;
            this.targetLocation = null;
            this.target = null;
            this.targetLocation = target;
            this.inertia = MissileMechanic.this.projectileInertia;
        }

        public AbstractLocation getTarget() {
            if (this.target != null) {
                return this.target.getLocation();
            }
            return this.targetLocation.clone();
        }

        @Override
        public void projectileStart() {
            float noise;
            this.velocity = MissileMechanic.this.projectileVelocity / MissileMechanic.this.ticksPerSecond;
            this.startLocation = MissileMechanic.this.fromOrigin ? this.data.getOrigin().clone() : this.data.getCaster().getEntity().getLocation().clone();
            this.targetYOffset = this.target != null ? (MissileMechanic.this.getTargetYOffset() == 0.0f ? this.target.getEyeLocation().getY() - this.target.getLocation().getY() : (double)MissileMechanic.this.getTargetYOffset()) : (double)MissileMechanic.this.getTargetYOffset();
            if (MissileMechanic.this.startYOffset != 0.0f) {
                this.startLocation.setY(this.startLocation.getY() + (double)MissileMechanic.this.startYOffset);
            }
            if (MissileMechanic.this.startForwardOffset != 0.0f) {
                this.startLocation = MythicUtil.move(this.startLocation, MissileMechanic.this.startForwardOffset, 0.0, 0.0);
            }
            if (MissileMechanic.this.startSideOffset != 0.0f) {
                this.startLocation = MythicUtil.move(this.startLocation, 0.0, 0.0, MissileMechanic.this.startSideOffset);
            }
            this.previousLocation = this.startLocation.clone();
            this.currentLocation = this.startLocation.clone();
            this.currentVelocity = this.getTarget().toVector().subtract(this.currentLocation.toVector()).normalize();
            if (MissileMechanic.this.projectileVelocityHorizOffset != 0.0f || MissileMechanic.this.projectileVelocityHorizNoise > 0.0f) {
                noise = 0.0f;
                if (MissileMechanic.this.projectileVelocityHorizNoise > 0.0f) {
                    noise = (float)((double)MissileMechanic.this.projectileVelocityHorizNoiseBase + Numbers.randomDouble() * (double)MissileMechanic.this.projectileVelocityHorizNoise);
                }
                this.currentVelocity.rotate(MissileMechanic.this.projectileVelocityHorizOffset + noise);
            }
            if (MissileMechanic.this.projectileVelocityVertOffset != 0.0f || MissileMechanic.this.projectileVelocityVertNoise > 0.0f) {
                noise = 0.0f;
                if (MissileMechanic.this.projectileVelocityVertNoise > 0.0f) {
                    noise = (float)((double)MissileMechanic.this.projectileVelocityVertNoiseBase + Numbers.randomDouble() * (double)MissileMechanic.this.projectileVelocityVertNoise);
                }
                this.currentVelocity.add(new AbstractVector(0.0f, MissileMechanic.this.projectileVelocityVertOffset + noise, 0.0f)).normalize();
            }
            if (MissileMechanic.this.powerAffectsVelocity) {
                this.velocity *= this.power;
            }
            this.currentVelocity.multiply(this.velocity);
        }

        @Override
        public void projectileTick() {
            this.previousLocation = this.currentLocation.clone();
            this.currentLocation.add(this.currentVelocity);
            this.currentVelocity.multiply(this.inertia);
            this.currentVelocity.add(this.getTarget().add(0.0, this.targetYOffset, 0.0).subtract(this.currentLocation.getX(), this.currentLocation.getY(), this.currentLocation.getZ()).toVector().normalize());
            this.currentVelocity.normalize().multiply(this.velocity);
            if (MissileMechanic.this.stopOnHitGround && !BlockUtil.isPathable(BukkitAdapter.adapt(this.currentLocation).getBlock(), this)) {
                this.terminate();
                return;
            }
            if (this.bullet != null) {
                this.applyBulletVelocity();
            }
            if (this.inRange != null) {
                this.inRange.forEach(e -> {
                    if (!e.isDead() && this.getBoundingBox().overlaps(e.getBukkitEntity().getBoundingBox()) && !this.immune.containsKey(e)) {
                        this.targets.add(e);
                        this.immune.put(e, System.currentTimeMillis() + 2000L);
                        if (MissileMechanic.this.stopOnHitEntity) {
                            this.doHit(this.targets);
                        }
                        return;
                    }
                });
                Iterator iter = this.immune.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    if ((Long)entry.getValue() >= System.currentTimeMillis()) continue;
                    iter.remove();
                }
            }
            if (MissileMechanic.this.onTickSkill.isPresent() && ((Skill)MissileMechanic.this.onTickSkill.get()).usable(this.data, null)) {
                SkillMetadata sData = this.data.deepClone();
                AbstractLocation location = MissileMechanic.this.bulletType == Projectile.BulletType.ARROW ? this.previousLocation.clone() : this.currentLocation.clone();
                ((Skill)MissileMechanic.this.onTickSkill.get()).execute(sData.setOrigin(location).setLocationTarget(location));
            }
            if (this.targets.size() > 0) {
                this.doHit((HashSet)this.targets.clone());
            }
            this.targets.clear();
        }

        public void setVelocity(double value) {
            this.currentVelocity = this.currentVelocity.normalize().multiply(value);
        }

        public void modifyVelocity(double v) {
            this.currentVelocity = this.currentVelocity.multiply(v);
        }

        public void setInertia(float p) {
            this.inertia = p;
        }

        public void modifyInertia(float p) {
            this.inertia *= p;
        }

        public void doHit(HashSet<AbstractEntity> targets) {
            if (MissileMechanic.this.onHitSkill.isPresent()) {
                SkillMetadata sData = this.data.deepClone();
                sData.setEntityTargets(targets);
                sData.setOrigin(this.currentLocation.clone());
                if (((Skill)MissileMechanic.this.onHitSkill.get()).usable(sData, null)) {
                    ((Skill)MissileMechanic.this.onHitSkill.get()).execute(sData);
                }
            }
            if (MissileMechanic.this.stopOnHitEntity) {
                this.terminate();
            }
        }

        @Override
        public void applyBulletVelocity() {
            if (MissileMechanic.this.bulletType == Projectile.BulletType.ITEM) {
                AbstractLocation ol = this.previousLocation.clone().subtract(0.0, 0.35, 0.0);
                AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().setItemPosition(this.bullet, ol);
                this.bullet.setVelocity(this.currentLocation.toVector().subtract(this.previousLocation.toVector()));
            } else if (MissileMechanic.this.bulletType == Projectile.BulletType.ARROW) {
                this.bullet.setVelocity(this.currentLocation.toVector().subtract(this.bullet.getLocation().clone().toVector()).multiply(0.25));
            } else if (MissileMechanic.this.bulletType == Projectile.BulletType.MOB) {
                AbstractLocation ol = this.previousLocation.clone().subtract(0.0, 1.35, 0.0);
                if (MissileMechanic.this.bulletSpin != 0.0f) {
                    float newSpin = this.bullet.getLocation().getYaw() + MissileMechanic.this.bulletSpin;
                    ol.setYaw(newSpin);
                }
                this.bullet.teleport(ol);
            } else {
                this.bullet.setVelocity(this.currentLocation.toVector().subtract(this.bullet.getLocation().clone().toVector()).multiply(1));
                if (MissileMechanic.this.bulletSpin > 0.0f) {
                    float newSpin = this.bullet.getLocation().getYaw() + MissileMechanic.this.bulletSpin;
                    AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().setEntityRotation(this.bullet, newSpin, newSpin);
                }
            }
        }
    }
}

