/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.MythicUtil;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.numbers.Numbers;
import org.bukkit.Location;
import org.bukkit.util.Vector;

@MythicMechanic(author="Ashijin", name="leap", description="Causes the caster to leap to the target location")
public class LeapMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected double velocity;
    protected double noise;

    public LeapMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.velocity = mlc.getDouble("v", 100.0);
        this.velocity = mlc.getDouble("velocity", this.velocity);
        this.velocity /= 10.0;
        this.noise = mlc.getDouble("noise", 1.0);
        this.noise = mlc.getDouble("noise", this.noise);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.Leap(data.getCaster(), target.getLocation(), data.getPower());
        return true;
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.Leap(data.getCaster(), target, data.getPower());
        return false;
    }

    protected void Leap(SkillCaster am, AbstractLocation location, float power) {
        int gravity = 20;
        double velocity = this.velocity * (1.0 + (double)power * 0.1);
        Location from = BukkitAdapter.adapt(am.getEntity().getLocation());
        Location to = BukkitAdapter.adapt(location);
        if (!from.getWorld().equals(to.getWorld())) {
            return;
        }
        Vector v = to.clone().subtract(from).toVector();
        Double elevation = v.getY();
        Double launchAngle = MythicUtil.calculateLaunchAngle(from, to, velocity, elevation, 20.0);
        Double distance = Math.sqrt(Math.pow(v.getX(), 2.0) + Math.pow(v.getZ(), 2.0));
        if (distance == 0.0) {
            return;
        }
        if (launchAngle == null) {
            launchAngle = Math.atan((40.0 * elevation + Math.pow(velocity, 2.0)) / (40.0 * elevation + 2.0 * Math.pow(velocity, 2.0)));
        }
        Double hangtime = MythicUtil.calculateHangtime(launchAngle, velocity, elevation, 20.0);
        v.setY(Math.tan(launchAngle) * distance);
        v = MythicUtil.normalizeVector(v);
        Vector noise = Vector.getRandom();
        noise = noise.multiply(this.noise / 10.0);
        v.add(noise);
        velocity = velocity + 1.188 * Math.pow(hangtime, 2.0) + (Numbers.randomDouble() - 0.8) / 2.0;
        v = v.multiply(velocity / 20.0);
        if (v.length() > 4.0) {
            v = v.normalize().multiply(4);
        }
        if (Double.isNaN(v.getX())) {
            v.setX(0);
        }
        if (Double.isNaN(v.getY())) {
            v.setY(0);
        }
        if (Double.isNaN(v.getZ())) {
            v.setZ(0);
        }
        am.getEntity().getBukkitEntity().setVelocity(v);
    }
}

