/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.SkillAdapter;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.items.MythicItem;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

@MythicMechanic(author="Ashijin", name="effect:itemspray", aliases={"itemspray", "e:itemspray"}, description="Sprays items everywhere")
public class ItemSprayEffect
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected String itemName;
    protected ItemStack item = null;
    protected int amount;
    protected int duration;
    protected double radius;
    protected double force;
    protected double yForce;
    protected double yOffset;
    protected boolean allowPickup;

    public ItemSprayEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.itemName = mlc.getString(new String[]{"item", "i"}, "iron_sword", new String[0]);
        this.amount = mlc.getInteger(new String[]{"amount", "a"}, 10);
        this.duration = mlc.getInteger(new String[]{"duration", "d"}, 20);
        this.radius = mlc.getDouble(new String[]{"radius", "r"}, 0.0);
        this.force = mlc.getDouble("force", 1.0);
        this.force = mlc.getDouble("f", this.force);
        this.force = mlc.getDouble("velocity", this.force);
        this.force = mlc.getDouble("v", this.force);
        this.yForce = mlc.getDouble("yforce", this.force);
        this.yForce = mlc.getDouble("yf", this.yForce);
        this.yForce = mlc.getDouble("yvelocity", this.yForce);
        this.yForce = mlc.getDouble("yv", this.yForce);
        this.yOffset = mlc.getDouble("yoffset", 1.0);
        this.yOffset = mlc.getDouble("y", this.yOffset);
        this.allowPickup = mlc.getBoolean(new String[]{"allowpickup", "ap"}, false);
        MythicMobs.inst().getSkillManager().queueSecondPass(() -> {
            Optional<MythicItem> maybeItem = MythicMobs.inst().getItemManager().getItem(this.itemName);
            if (maybeItem.isPresent()) {
                this.item = BukkitAdapter.adapt(maybeItem.get().generateItemStack(1));
            } else {
                try {
                    this.item = new ItemStack(Material.valueOf((String)this.itemName.toUpperCase()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playEffect(target);
        return false;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.playEffect(target.getLocation());
        return false;
    }

    protected void playEffect(AbstractLocation l) {
        if (this.item == null) {
            Optional<MythicItem> maybeItem = MythicMobs.inst().getItemManager().getItem(this.itemName);
            if (maybeItem.isPresent()) {
                this.item = BukkitAdapter.adapt(maybeItem.get().generateItemStack(1));
            } else {
                try {
                    this.item = new ItemStack(Material.valueOf((String)this.itemName.toUpperCase()));
                }
                catch (Exception ex) {
                    if (ConfigManager.debugLevel > 0) {
                        ex.printStackTrace();
                    }
                    MythicLogger.error("Executing ItemSprayEffect failed: Could not find item " + this.itemName);
                    return;
                }
            }
        }
        SkillAdapter.get().itemSprayEffect(l, this.item, this.amount, this.duration, this.force, this.yForce, this.radius, this.yOffset, this.allowPickup);
    }
}

