/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.drops.EquipSlot;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@MythicMechanic(author="Ashijin", name="giveitemfromslot", aliases={"givefromslot"}, description="Gives the target an item in the caster's equipment")
public class GiveItemFromSlotMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    private EquipSlot slot;
    private boolean doFakeLooting;

    public GiveItemFromSlotMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.doFakeLooting = mlc.getBoolean(new String[]{"fakelooting", "fl"}, false);
        String itemString = mlc.getString(new String[]{"slot", "s"});
        this.slot = EquipSlot.of(itemString);
        if (this.slot == EquipSlot.NONE) {
            MythicLogger.errorMechanicConfig(this, mlc, "Invalid item slot supplied.");
            return;
        }
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        Optional<ItemStack> maybeItem = this.slot.get(data.getCaster().getEntity());
        if (!maybeItem.isPresent()) {
            return false;
        }
        if (!target.isPlayer()) {
            return true;
        }
        Player player = (Player)target.getBukkitEntity();
        ItemStack stack = maybeItem.get();
        player.getInventory().addItem(new ItemStack[]{stack}).forEach((i, is) -> player.getWorld().dropItemNaturally(player.getLocation(), is));
        if (this.doFakeLooting) {
            int id = GiveItemFromSlotMechanic.getPlugin().getVolatileCodeHandler().getItemHandler().spawnFakeItem(player, stack, data.getOrigin());
            Schedulers.sync().runLater(() -> GiveItemFromSlotMechanic.getPlugin().getVolatileCodeHandler().getItemHandler().collectFakeItem(player, id), 5L);
        }
        return true;
    }
}

