/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.tasks.Task;
import io.lumine.xikage.mythicmobs.volatilecode.VolatileMaterial;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.Block;

@MythicMechanic(author="Ashijin", name="effect:geyser", aliases={"geyser", "e:geyser"}, description="Creates a geyser at the target location")
public class GeyserEffect
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    private int height;
    private int tickInterval;
    private Material type;

    public GeyserEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.height = mlc.getInteger(new String[]{"height", "h"}, 3);
        this.tickInterval = mlc.getInteger(new String[]{"interval", "i", "speed", "s"}, 10);
        String strType = mlc.getString(new String[]{"type", "t"}, "water", new String[0]);
        this.type = strType.equalsIgnoreCase("lava") ? VolatileMaterial.LAVA : (strType.equalsIgnoreCase("water") ? VolatileMaterial.WATER : VolatileMaterial.WATER);
        if (this.height <= 0) {
            this.height = 1;
        }
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playEffect(data.getCaster(), target);
        return true;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.playEffect(data.getCaster(), target.getLocation());
        return true;
    }

    protected void playEffect(SkillCaster am, AbstractLocation target) {
        List<AbstractPlayer> players = target.getWorld().getPlayersNearLocation(target, 50);
        new Animator(target, players);
    }

    private class Animator
    implements Runnable {
        private Task task;
        private int tick = 0;
        private AbstractLocation start;
        private List<AbstractPlayer> nearby;

        public Animator(AbstractLocation start, List<AbstractPlayer> nearby) {
            this.start = start;
            this.nearby = nearby;
            this.task = Schedulers.sync().runRepeating(this, 0L, (long)GeyserEffect.this.tickInterval);
        }

        @Override
        public void run() {
            try {
                if (this.tick > GeyserEffect.this.height * 2) {
                    this.task.terminate();
                } else if (this.tick < GeyserEffect.this.height) {
                    Block block = BukkitAdapter.adapt(this.start.clone().add(0.0, this.tick, 0.0)).getBlock();
                    if (block.getType() == Material.AIR) {
                        for (AbstractPlayer p : this.nearby) {
                            BukkitAdapter.adapt(p).sendBlockChange(block.getLocation(), GeyserEffect.this.type, (byte)0);
                        }
                    }
                } else {
                    int n = GeyserEffect.this.height - (this.tick - GeyserEffect.this.height) - 1;
                    Block block = BukkitAdapter.adapt(this.start.clone().add(0.0, n, 0.0)).getBlock();
                    for (AbstractPlayer p : this.nearby) {
                        BukkitAdapter.adapt(p).sendBlockChange(block.getLocation(), block.getType(), block.getData());
                    }
                }
                ++this.tick;
            }
            catch (Exception ex) {
                if (ConfigManager.debugLevel > 0) {
                    ex.printStackTrace();
                }
                this.task.terminate();
            }
        }
    }
}

