/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.auras.Aura;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="fly", description="Aura that enables flying on the target entity")
public class FlyMechanic
extends Aura
implements ITargetedEntitySkill {
    public FlyMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isPlayer()) {
            new FlyMechanicTracker(target, data);
        }
        return true;
    }

    public class FlyMechanicTracker
    extends Aura.AuraTracker {
        private boolean couldFly;

        public FlyMechanicTracker(AbstractEntity target, SkillMetadata data) {
            super((Aura)FlyMechanic.this, target, data);
            this.start();
        }

        @Override
        public void auraStart() {
            this.executeAuraSkill(FlyMechanic.this.onStartSkill, this.skillMetadata);
            this.couldFly = this.skillMetadata.getCaster().getEntity().asPlayer().getAllowFlight();
            this.skillMetadata.getCaster().getEntity().asPlayer().setAllowFlight(true);
            this.skillMetadata.getCaster().getEntity().asPlayer().setFlying(true);
        }

        @Override
        public void auraStop() {
            this.skillMetadata.getCaster().getEntity().asPlayer().setFlying(false);
            this.skillMetadata.getCaster().getEntity().asPlayer().setAllowFlight(this.couldFly);
            this.executeAuraSkill(FlyMechanic.this.onEndSkill, this.skillMetadata);
        }
    }
}

