/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import com.google.common.collect.Lists;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitItemStack;
import io.lumine.xikage.mythicmobs.drops.Drop;
import io.lumine.xikage.mythicmobs.drops.DropMetadata;
import io.lumine.xikage.mythicmobs.drops.DropTable;
import io.lumine.xikage.mythicmobs.drops.LootBag;
import io.lumine.xikage.mythicmobs.drops.droppables.ItemDrop;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillString;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.block.Chest;
import org.bukkit.inventory.ItemStack;

@MythicMechanic(author="Ashijin", name="fillChest", aliases={"populateChest"}, description="Fills a chest with loot")
public class FillChestMechanic
extends SkillMechanic
implements ITargetedLocationSkill {
    private DropTable dropTable;

    public FillChestMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        String itemString = mlc.getString(new String[]{"items", "item", "i"});
        Optional<DropTable> maybeTable = FillChestMechanic.getPlugin().getDropManager().getDropTable(itemString);
        if (maybeTable.isPresent()) {
            this.dropTable = maybeTable.get();
            return;
        }
        if (itemString.startsWith("\"")) {
            try {
                itemString = itemString.substring(1, itemString.length() - 1);
            }
            catch (Exception ex) {
                MythicLogger.errorMechanicConfig(this, mlc, "The 'items' attribute is required.");
            }
            itemString = SkillString.parseMessageSpecialChars(itemString);
        }
        ArrayList<String> items = new ArrayList<String>(Arrays.asList(itemString.split(",")));
        this.dropTable = new DropTable("FillChestMechanic", "FillChestMechanic", items);
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        LootBag loot = this.dropTable.generate(new DropMetadata(data.getCaster(), data.getCaster().getEntity()));
        Location location = BukkitAdapter.adapt(data.getOrigin());
        if (!(location.getBlock().getState() instanceof Chest)) {
            MythicLogger.error("Location " + location.toString() + " was not a chest");
            return false;
        }
        Chest chest = (Chest)location.getBlock().getState();
        ArrayList<ItemStack> items = Lists.newArrayList();
        for (Drop drop : loot.getLootTable()) {
            if (!(drop instanceof ItemDrop)) continue;
            ItemStack stack = ((BukkitItemStack)((ItemDrop)drop).getDrop(new DropMetadata(data.getCaster(), data.getCaster().getEntity()))).build();
            items.add(stack);
        }
        for (ItemStack itemStack : items) {
            int slot = -1;
            do {
                slot = (int)(Math.random() * (double)chest.getInventory().getSize());
            } while (chest.getInventory().getItem(slot) != null);
            int fslot = slot;
            Schedulers.sync().run(() -> chest.getInventory().setItem(fslot, itemStack));
        }
        return true;
    }
}

